/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.BufferedOutputStream;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.BufferedOutputStream.SMExBufferedOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;

public class SMBufferedOutputStreamTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.BufferedOutputStream");
        this.test_BufferedOutputStream();
        this.test_write();
        this.test_flush();
        this.test_flushplus();
    }

    public void test_BufferedOutputStream() {
        this.th.checkPoint("BufferedOutputStream(java.io.OutputStream)");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SMExBufferedOutputStream xbuf = new SMExBufferedOutputStream(bos);
        boolean bl = false;
        if (xbuf.getbuf().length == 512) {
            bl = true;
        }
        this.th.check(bl, "checking default size");
        boolean bl2 = false;
        if (xbuf.getcount() == 0) {
            bl2 = true;
        }
        this.th.check(bl2, "checking initial count");
        this.th.checkPoint("BufferedOutputStream(java.io.OutputStream,int)");
        xbuf = new SMExBufferedOutputStream(bos, 30);
        boolean bl3 = false;
        if (xbuf.getbuf().length == 30) {
            bl3 = true;
        }
        this.th.check(bl3, "checking default size");
        boolean bl4 = false;
        if (xbuf.getcount() == 0) {
            bl4 = true;
        }
        this.th.check(bl4, "checking initial count");
        try {
            new BufferedOutputStream(bos, 0);
            this.th.fail("should throw a IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
        try {
            new BufferedOutputStream(bos, -1);
            this.th.fail("should throw a IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ne) {
            this.th.check(true);
        }
    }

    public void test_write() {
        this.th.checkPoint("write(int)void");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SMExBufferedOutputStream xbuf = new SMExBufferedOutputStream(bos, 6);
        try {
            xbuf.write(97);
            xbuf.write(98);
            boolean bl = false;
            if (xbuf.getcount() == 2) {
                bl = true;
            }
            this.th.check(bl, "checking count -- 1");
            xbuf.write(99);
            xbuf.write(99);
            boolean bl2 = false;
            if (xbuf.getcount() == 4) {
                bl2 = true;
            }
            this.th.check(bl2, "checking count -- 2");
            xbuf.write(98);
            xbuf.write(97);
            boolean bl3 = false;
            if (xbuf.getcount() == 6) {
                bl3 = true;
            }
            this.th.check(bl3, "checking count -- 3");
            this.th.check(xbuf.toString().equals("abccba"), "checking writting in buffer -- 1");
            this.th.check(bos.toString().equals(""), "nothing written downstream");
            xbuf.write(97);
            this.th.check(xbuf.toString().equals("a"), "checking writting in buffer -- 2");
            this.th.check(bos.toString().equals("abccba"), "now we have written downstream");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception:" + e);
        }
        this.th.checkPoint("write(byte[],int,int)void");
        bos = new ByteArrayOutputStream();
        xbuf = new SMExBufferedOutputStream(bos, 6);
        String s = "Smartmove!";
        byte[] b = s.getBytes();
        try {
            xbuf.write(b, 0, 10);
            boolean bl = false;
            if (xbuf.getcount() == 0) {
                bl = true;
            }
            this.th.check(bl, "checking count -- 1");
            this.th.check(bos.toString().equals(s), "checking what is written downstream -- 1");
            xbuf.write(b, 5, 3);
            boolean bl4 = false;
            if (xbuf.getcount() == 3) {
                bl4 = true;
            }
            this.th.check(bl4, "checking count -- 2");
            this.th.check(xbuf.toString().equals("mov"), "checking writting in buffer -- 1");
            this.th.check(bos.toString().equals(s), "checking what is written downstream -- 2");
            xbuf.write(b, 7, 3);
            boolean bl5 = false;
            if (xbuf.getcount() == 6) {
                bl5 = true;
            }
            this.th.check(bl5, "checking count -- 3");
            this.th.check(xbuf.toString().equals("movve!"), "checking writting in buffer -- 2");
            this.th.check(bos.toString().equals(s), "checking what is written downstream -- 3");
            xbuf.write(b, 0, 0);
            boolean bl6 = false;
            if (xbuf.getcount() == 6) {
                bl6 = true;
            }
            this.th.check(bl6, "checking count -- 4");
            this.th.check(xbuf.toString().equals("movve!"), "checking writting in buffer -- 3");
            this.th.check(bos.toString().equals(s), "checking what is written downstream -- 4");
            xbuf.write(b, 0, 5);
            this.th.check(xbuf.getcount(), 5, "checking count -- 5, got:" + xbuf.getcount());
            this.th.check(bos.toString(), s + "movve!", "checking what is written downstream -- 5, got:" + bos.toString());
            bos = new ByteArrayOutputStream();
            xbuf = new SMExBufferedOutputStream(bos, 6);
            xbuf.write(b, 5, 3);
            boolean bl7 = false;
            if (xbuf.getcount() == 3) {
                bl7 = true;
            }
            this.th.check(bl7, "checking count -- 6");
            this.th.check(xbuf.toString().equals("mov"), "checking writting in buffer -- 4");
            this.th.check(bos.toString().equals(""), "checking what is written downstream -- 6");
            xbuf.write(b, 0, 10);
            boolean bl8 = false;
            if (xbuf.getcount() == 0) {
                bl8 = true;
            }
            this.th.check(bl8, "checking count -- 7");
            this.th.check(bos.toString().equals("mov" + s), "checking what is written downstream -- 7");
            bos = new ByteArrayOutputStream();
            xbuf = new SMExBufferedOutputStream(bos, 6);
            xbuf.write(b, 0, 3);
            this.th.check(xbuf.getcount(), 3, "checking count -- 8");
            this.th.check(xbuf.toString(), "Sma", "checking writting in buffer -- 8");
            this.th.check(bos.toString(), "", "checking what is written downstream -- 8");
            xbuf.write(b, 3, 5);
            this.th.check(xbuf.getcount(), 5, "checking count -- 9");
            this.th.check(xbuf.toString(), "rtmov", "checking writting in buffer -- 9");
            this.th.check(bos.toString(), "Sma", "checking what is written downstream -- 9");
            xbuf.write(b, 0, 9);
            this.th.check(xbuf.getcount(), 0, "checking count -- 10");
            this.th.check(xbuf.toString(), "", "checking writting in buffer -- 10");
            this.th.check(bos.toString(), "SmartmovSmartmove", "checking what is written downstream -- 10");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
        }
        try {
            xbuf.write(null, 1, 2);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 2, got:" + e);
        }
        try {
            xbuf.write(b, -1, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 3, got:" + e);
        }
        try {
            xbuf.write(b, 11, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 4, got:" + e);
        }
        try {
            xbuf.write(b, 5, -2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 5, got:" + e);
        }
        try {
            xbuf.write(b, 5, 6);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 6, got:" + e);
        }
        boolean bl = false;
        if (xbuf.getcount() == 0) {
            bl = true;
        }
        this.th.check(bl, "checking count -- 8");
        this.th.checkPoint("write(byte[],int,int)void");
        try {
            b = new byte[]{97, 98, 99};
            bos = new ByteArrayOutputStream();
            xbuf = new SMExBufferedOutputStream(bos, 6);
            xbuf.write(b);
            boolean bl9 = false;
            if (xbuf.getcount() == 3) {
                bl9 = true;
            }
            this.th.check(bl9, "checking count -- special");
            this.th.check(xbuf.toString().equals("abc"), "checking writting in buffer -- special");
            this.th.check(bos.toString().equals(""), "checking what is written downstream -- special");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 6, got:" + e);
        }
    }

    public void test_flush() {
        this.th.checkPoint("flush()void");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SMExBufferedOutputStream xbuf1 = new SMExBufferedOutputStream(bos, 60);
        SMExBufferedOutputStream xbuf = new SMExBufferedOutputStream(xbuf1, 6);
        try {
            byte[] b = new byte[]{97, 98, 99};
            xbuf.write(b, 0, 3);
            xbuf.flush();
            boolean bl = false;
            if (xbuf.getcount() == 0) {
                bl = true;
            }
            this.th.check(bl, "checking count -- 1");
            this.th.check(xbuf.toString().equals(""), "checking writting in buffer -- 1");
            boolean bl2 = false;
            if (xbuf1.getcount() == 0) {
                bl2 = true;
            }
            this.th.check(bl2, "checking count -- 2");
            this.th.check(xbuf1.toString().equals(""), "checking writting in buffer -- 2");
            this.th.check(bos.toString().equals("abc"), "checking flusf goes downstream -- 1");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
        }
    }

    public void test_flushplus() {
        this.th.checkPoint("flush()void");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SMExBufferedOutputStream xbuf1 = new SMExBufferedOutputStream(bos, 60);
        SMExBufferedOutputStream xbuf = new SMExBufferedOutputStream(xbuf1, 6);
        try {
            String s = "Smartmove!";
            byte[] b = s.getBytes();
            xbuf.write(b, 0, 10);
            xbuf.write(b, 5, 3);
            xbuf.write(b, 7, 3);
            xbuf.write(b, 0, 5);
            xbuf.write(b, 5, 3);
            int i = 0;
            while (i < 7) {
                xbuf.write((byte)i);
                ++i;
            }
            this.th.check(bos.toString().equals(""), "checking what is written downstream -- 1");
        }
        catch (Exception e) {
            this.th.fail("got unexpected exception -- 1, got:" + e);
        }
    }
}

