/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet;

import gnu.testlet.ResourceNotFoundException;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class TestRunner
extends TestHarness {
    static final String TESTCLASSFILE = new String("wonkatest.properties");
    private int count = 0;
    private int failures = 0;
    private int total = 0;
    private int loop = 0;
    private boolean verbose = false;
    private boolean debug = false;
    private String description;
    private String classname;
    private String current_checkitem;
    private FileWriter outfile = null;
    static int loops = 0;

    protected TestRunner(boolean verbose, boolean debug, int loop) {
        this.verbose = verbose;
        this.debug = debug;
        this.loop = loop;
    }

    public TestRunner() {
    }

    protected void decodeLine(String line) {
        if ((line = line.trim()).length() == 0) {
            this.printLine(line);
        } else if (line.startsWith("//")) {
            this.printLine("   ( " + line.substring(2) + " )");
        } else if (line.startsWith("#")) {
            this.printLine("    => " + line.substring(1));
        } else if (line.toLowerCase().startsWith("def")) {
            if ((line = line.substring(3).trim()).equalsIgnoreCase("debug")) {
                this.setDebug(true);
            } else if (line.equalsIgnoreCase("nodebug")) {
                this.setDebug(false);
            } else if (line.equalsIgnoreCase("verbose")) {
                this.setVerbose(true);
            } else if (line.equalsIgnoreCase("noverbose")) {
                this.setVerbose(false);
            } else if (line.toLowerCase().startsWith("file")) {
                line = line.substring(4).trim();
                this.setOutputFile(line);
            } else if (line.equalsIgnoreCase("nofile")) {
                this.closeOutputFile();
            }
        } else {
            this.verbose("----");
            this.verbose(line);
            this.runtest(line);
        }
    }

    protected void runtest(String name) {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        System.gc();
        System.runFinalization();
        long tot = rt.totalMemory();
        this.debug("TESTRUNNER -- MEMORY STATUS : " + (tot - rt.freeMemory()) + " used of " + tot + " before starting '" + name + "' (was before gc " + (tot - free) + ")");
        this.checkPoint(null);
        Testlet t = null;
        try {
            Class<?> k = Class.forName(name);
            Object o = k.newInstance();
            if (o instanceof Testlet) {
                t = (Testlet)o;
            }
        }
        catch (Throwable ex) {
            this.printLine("FAIL: uncaught exception loading " + name);
            this.verbose("error : " + ex.toString());
            this.debug(ex);
            if (this.debug) {
                ex.printStackTrace();
            }
            ++this.failures;
            ++this.total;
        }
        if (t != null) {
            this.description = name;
            try {
                t.test(this);
            }
            catch (Throwable ex) {
                this.printLine("FAIL $$" + this.classname + "$$" + this.current_checkitem + "$$uncaught '" + ex + "' while running '" + name + "'$$");
                this.verbose("error : " + ex.toString());
                this.debug(ex);
                if (this.debug) {
                    ex.printStackTrace();
                }
                ++this.failures;
                ++this.total;
            }
        }
    }

    protected int done() {
        this.printLine(this.failures + " of " + this.total + " tests failed" + (loops > 0 ? "during pass " + (this.loop + 1) + " of " + loops : ""));
        if (this.outfile != null) {
            this.closeOutputFile();
        }
        return this.failures > 0 ? 1 : 0;
    }

    public void check(boolean check_succeeded) {
        this.check(check_succeeded, "no Message");
    }

    public void check(boolean check_succeeded, String message) {
        if (!check_succeeded) {
            this.printLine(this.getDescription("FAIL $$" + this.classname + "$$" + this.current_checkitem + "$$" + message + "$$"));
            ++this.failures;
        } else {
            this.verbose(this.getDescription("PASS $$" + this.classname + "$$" + this.current_checkitem + "$$" + message + "$$"));
        }
        ++this.count;
        ++this.total;
    }

    public void checkPoint(String checkitemname) {
        this.current_checkitem = checkitemname;
        this.count = 0;
    }

    public void setclass(String cname) {
        this.classname = cname;
    }

    public String getTestClass() {
        return this.classname;
    }

    public String getCheckPoint() {
        return this.current_checkitem;
    }

    public int getTestsTotal() {
        return this.total;
    }

    public int getTestsFailed() {
        return this.failures;
    }

    public void setDebug(boolean state) {
        this.debug = state;
        if (state) {
            this.printLine("***  set Debug  ***");
        } else {
            this.printLine("***  Debug off  ***");
        }
    }

    public void setVerbose(boolean state) {
        this.verbose = state;
        if (state) {
            this.printLine("*** set Verbose ***");
        } else {
            this.printLine("*** verbose off ***");
        }
    }

    public void setOutputFile(String name) {
        try {
            if (loops > 0) {
                name = name + "." + (this.loop + 1);
            }
            this.printLine("*** Write output to <" + name + "> ***");
            this.outfile = new FileWriter(name);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e);
            this.outfile = null;
        }
    }

    public void closeOutputFile() {
        if (this.outfile == null) {
            this.printLine("*** no output file to close ***");
        } else {
            try {
                this.outfile.close();
                this.outfile = null;
                this.printLine("*** output file closed ***");
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (File.separator.length() > 1) {
            throw new Error("File.separator length is greater than 1");
        }
        String realName = name.replace('#', File.separator.charAt(0));
        InputStream s = ClassLoader.getSystemResourceAsStream(name);
        if (s == null) {
            throw new ResourceNotFoundException();
        }
        return s;
    }

    public Reader getResourceReader(InputStream istream) throws ResourceNotFoundException {
        return new BufferedReader(new InputStreamReader(istream));
    }

    public Reader getResourceReader(String name) throws ResourceNotFoundException {
        return new BufferedReader(new InputStreamReader(this.getResourceStream(name)));
    }

    public void printSingle(String message) {
        System.out.print(message);
        if (this.outfile != null) {
            try {
                this.outfile.write(message);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public void printLine(String message) {
        System.out.println(message);
        if (this.outfile != null) {
            try {
                this.outfile.write(message + "\n");
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public void printLine(String message, boolean write_always) {
        if (write_always || this.verbose) {
            this.printLine(message);
        }
    }

    public void verbose(String message) {
        if (this.verbose) {
            this.printLine(message);
        }
    }

    public void debug(String message) {
        if (this.debug) {
            this.printLine(message);
        }
    }

    public void debug(String message, boolean newline2) {
        if (this.debug && newline2) {
            this.printLine(message);
        } else if (this.debug) {
            this.printSingle(message);
        }
    }

    public void debug(Throwable ex) {
        if (this.debug) {
            this.printLine(ex.getMessage());
            this.printLine(ex.toString());
        }
    }

    public void debug(Object[] o, String desc) {
        this.debug("Dumping Object Array: " + desc);
        if (o == null) {
            this.debug("null");
            return;
        }
        for (int i = 0; i < o.length; ++i) {
            if (o[i] instanceof Object[]) {
                this.debug((Object[])o[i], desc + " element " + i);
                continue;
            }
            this.debug("  Element " + i + ": " + o[i]);
        }
    }

    private final String getDescription(String pf) {
        String completedescription = pf + ": " + this.description;
        if (this.current_checkitem != null) {
            completedescription = completedescription + ": " + this.current_checkitem;
        }
        completedescription = completedescription + " (number " + (this.count + 1) + ")";
        return completedescription;
    }

    public String getSourceDirectory() {
        return new String("");
    }

    public String getTempDirectory() {
        return new String("");
    }

    public static void runTests(TestRunner runner, String testfile) {
        BufferedReader r = null;
        try {
            r = (BufferedReader)runner.getResourceReader(testfile);
        }
        catch (ResourceNotFoundException ex) {
            runner.printLine(ex.getLocalizedMessage());
            return;
        }
        String cname = null;
        boolean notflaggedoff = true;
        try {
            cname = r.readLine();
            runner.verbose(cname);
        }
        catch (IOException iox) {
            System.err.println(iox.getLocalizedMessage());
        }
        while (cname != null) {
            try {
                int flaggedoffstart = cname.indexOf("/*");
                int flaggedoffstop = cname.indexOf("*/");
                String cname_always = "";
                while (flaggedoffstart >= 0 || flaggedoffstop >= 0) {
                    if (flaggedoffstart >= 0 && flaggedoffstop >= 0) {
                        if (flaggedoffstart < flaggedoffstop && notflaggedoff) {
                            cname = cname.substring(0, flaggedoffstart) + cname.substring(flaggedoffstop + 2);
                        } else if (flaggedoffstart > flaggedoffstop && !notflaggedoff) {
                            cname_always = cname_always + cname.substring(flaggedoffstop + 2, flaggedoffstart);
                            cname = cname.substring(flaggedoffstart + 2);
                        } else if (flaggedoffstart < flaggedoffstop && !notflaggedoff) {
                            cname = cname.substring(flaggedoffstop + 2);
                            notflaggedoff = true;
                        } else if (flaggedoffstart > flaggedoffstop && notflaggedoff) {
                            cname_always = cname_always + cname.substring(flaggedoffstop + 2, flaggedoffstart);
                            cname = cname.substring(flaggedoffstart + 2);
                            notflaggedoff = false;
                        }
                    } else if (flaggedoffstart >= 0) {
                        if (notflaggedoff) {
                            cname_always = cname_always + cname.substring(0, flaggedoffstart);
                        }
                        cname = cname.substring(flaggedoffstart + 2);
                        notflaggedoff = false;
                    } else if (flaggedoffstop >= 0) {
                        cname = cname.substring(flaggedoffstop + 2);
                        notflaggedoff = true;
                    }
                    flaggedoffstart = cname.indexOf("/*");
                    flaggedoffstop = cname.indexOf("*/");
                }
                if (notflaggedoff) {
                    runner.decodeLine(cname_always + cname);
                } else if (cname_always.length() > 0) {
                    runner.decodeLine(cname_always);
                }
                cname = r.readLine();
            }
            catch (IOException iox) {
                System.err.println(iox.getLocalizedMessage());
            }
        }
    }

    public static void main(String[] args) {
        boolean verbose = false;
        boolean debug = false;
        String testfile = TESTCLASSFILE;
        Object outfile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-debug")) {
                debug = true;
                continue;
            }
            try {
                int temp = Integer.parseInt(args[i]);
                if (loops < 0) {
                    System.err.println("*** negative number of passes, ignoring ***");
                    continue;
                }
                loops = temp;
                continue;
            }
            catch (NumberFormatException nfe) {
                testfile = args[i];
            }
        }
        TestRunner runner = null;
        for (int j = 0; j < (loops == 0 ? 1 : loops); ++j) {
            runner = new TestRunner(verbose, debug, j);
            TestRunner.runTests(runner, testfile);
            runner.done();
            System.out.println("\n");
        }
        System.exit(0);
    }
}

