/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet;

import gnu.testlet.ResourceNotFoundException;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SingleTestRunner
extends TestHarness {
    static final String TESTCLASSFILE = new String("wonkatests");
    private int count;
    private int failures;
    private int total;
    private boolean verbose;
    private boolean debug;
    private String classname;
    private String description;
    private String current_checkitem;

    protected void runtest(String name) {
        System.gc();
        System.runFinalization();
        this.checkPoint(null);
        Testlet t = null;
        try {
            this.verbose("... Loading Class <" + name + '>');
            Class<?> k = Class.forName(name);
            if (k == null) {
                this.debug("class <" + name + "> could not be loaded");
            } else {
                this.verbose("... Constructing instance <" + name + '>');
                Object o = k.newInstance();
                if (o == null) {
                    this.debug("instance <" + name + "> could not be built");
                } else if (!(o instanceof Testlet)) {
                    this.debug("Not of type testlet");
                } else {
                    t = (Testlet)o;
                    this.verbose("... Running testlet<" + name + "> : ");
                }
            }
        }
        catch (Throwable ex) {
            this.printLine("FAIL: uncaught exception loading " + name);
            this.verbose("error : " + ex.toString());
            this.debug(ex);
            ++this.failures;
            ++this.total;
        }
        if (t != null) {
            this.description = name;
            this.verbose("testing " + this.description);
            try {
                t.test(this);
            }
            catch (Throwable ex) {
                if (this.current_checkitem != null) {
                    this.printLine("FAIL: " + name + ": uncaught exception at  < " + this.current_checkitem + " >  number " + (this.count + 1));
                } else {
                    this.printLine("FAIL: " + name + ": uncaught exception at check number " + (this.count + 1));
                }
                this.verbose("error : " + ex.toString());
                this.debug(ex);
                ++this.failures;
                ++this.total;
            }
        }
    }

    protected int done() {
        this.printLine(this.failures + " of " + this.total + " tests failed");
        int n = 0;
        if (this.failures > 0) {
            n = 1;
        }
        return n;
    }

    public void check(boolean check_succeeded) {
        this.check(check_succeeded, "no message");
    }

    public void check(boolean check_succeeded, String message) {
        if (!check_succeeded) {
            this.printLine(this.getDescription("FAIL $$" + this.classname + "$$" + this.current_checkitem + "$$" + message + "$$"));
            ++this.failures;
        } else {
            this.verbose(this.getDescription("PASS " + message));
        }
        ++this.count;
        ++this.total;
    }

    public void checkPoint(String checkitemname) {
        this.current_checkitem = checkitemname;
        this.count = 0;
        this.verbose("");
        this.verbose("      <" + checkitemname + '>');
    }

    public void setclass(String cname) {
        this.classname = cname;
    }

    public void setDebug(boolean state) {
        this.debug = state;
        if (state) {
            this.printLine("***  set Debug  ***");
        } else {
            this.printLine("***  Debug off  ***");
        }
    }

    public void setVerbose(boolean state) {
        this.verbose = state;
        if (state) {
            this.printLine("*** set Verbose ***");
        } else {
            this.printLine("*** verbose off ***");
        }
    }

    public void setOutputFile(String name) {
    }

    public void closeOutputFile() {
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (File.separator.length() > 1) {
            throw new Error("File.separator length is greater than 1");
        }
        String realName = name.replace('#', File.separator.charAt(0));
        InputStream s = ClassLoader.getSystemResourceAsStream(name);
        if (s == null) {
            throw new ResourceNotFoundException();
        }
        return s;
    }

    public Reader getResourceReader(InputStream istream) throws ResourceNotFoundException {
        return new BufferedReader(new InputStreamReader(istream));
    }

    public Reader getResourceReader(String name) throws ResourceNotFoundException {
        return new BufferedReader(new InputStreamReader(this.getResourceStream(name)));
    }

    public void printSingle(String message) {
        System.out.print(message);
    }

    public void printLine(String message) {
        System.out.println(message);
    }

    public void printLine(String message, boolean write_always) {
        if (write_always || this.verbose) {
            this.printLine(message);
        }
    }

    public void verbose(String message) {
        if (this.verbose) {
            this.printLine(message);
        }
    }

    public void debug(String message) {
        if (this.debug) {
            this.printLine(message);
        }
    }

    public void debug(String message, boolean newline2) {
        if (this.debug && newline2) {
            this.printLine(message);
        } else if (this.debug) {
            this.printSingle(message);
        }
    }

    public void debug(Throwable ex) {
        if (this.debug) {
            this.printLine("Exception <" + ex.getMessage() + "> : " + ex.toString());
        }
    }

    public void debug(Object[] o, String desc) {
        this.debug("Dumping Object Array: " + desc);
        if (o == null) {
            this.debug("null");
            return;
        }
        int i = 0;
        while (i < o.length) {
            if (o[i] instanceof Object[]) {
                this.debug((Object[])o[i], desc + " element " + i);
            } else {
                this.debug("  Element " + i + ": " + o[i]);
            }
            ++i;
        }
    }

    private final String getDescription(String pf) {
        String completedescription = pf + ": " + this.description;
        if (this.current_checkitem != null) {
            completedescription = completedescription + ": " + this.current_checkitem;
        }
        completedescription = completedescription + " (number " + (this.count + 1) + ')';
        return completedescription;
    }

    public String getSourceDirectory() {
        return new String("");
    }

    public String getTempDirectory() {
        return new String("");
    }

    public static void main(String[] args) {
        boolean verbose = false;
        boolean debug = false;
        boolean immediately = false;
        String testfile = null;
        String outfile = "TestHarnessOut.scr";
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-v")) {
                verbose = true;
            } else if (args[i].equalsIgnoreCase("-d")) {
                debug = true;
            } else if (args[i].equalsIgnoreCase("-o")) {
                if (i < args.length - 1) {
                    outfile = args[i + 1];
                    ++i;
                }
            } else {
                testfile = args[i];
            }
            ++i;
        }
        SingleTestRunner runner = new SingleTestRunner(verbose, debug);
        runner.setOutputFile(outfile);
        runner.runtest(testfile);
        runner.done();
    }

    private final /* synthetic */ void this() {
        this.count = 0;
        this.failures = 0;
        this.total = 0;
        this.verbose = false;
        this.debug = false;
    }

    protected SingleTestRunner(boolean verbose, boolean debug) {
        this.this();
        this.verbose = verbose;
        this.debug = debug;
    }
}

