/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.Junittests.io;

import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_B;
import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_C;
import gnu.testlet.Junittests.io.SAMPLE_SerialObject;
import gnu.testlet.Mv_Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TEST_ObjectOutputStream_Values_C2
extends Mv_Assert {
    private SAMPLE_ObjectStream_B root = SAMPLE_SerialObject.getRootObject();
    private SAMPLE_ObjectStream_C check;
    private SAMPLE_ObjectStream_C original = (SAMPLE_ObjectStream_C)this.root.getLeft().getRight();
    private Object object;
    private ObjectInputStream ois;
    private ByteArrayInputStream bais;
    private ByteArrayOutputStream baos;
    private ObjectOutputStream oos;
    private byte[] output;
    private static final double DELTA = 1.0E-6;

    public void setUp() {
        this.openOutputStream();
        try {
            this.oos.writeObject(this.root);
            this.oos.flush();
        }
        catch (IOException ioe) {
            this.closeOutputStream();
            TEST_ObjectOutputStream_Values_C2.fail(ioe.toString());
        }
        this.output = this.baos.toByteArray();
        this.closeOutputStream();
        this.openInputStream(this.output);
        try {
            this.object = this.ois.readObject();
        }
        catch (Exception e) {
            TEST_ObjectOutputStream_Values_C2.fail(e.toString());
        }
        this.closeInputStream();
        this.check = (SAMPLE_ObjectStream_C)((SAMPLE_ObjectStream_B)this.object).getLeft().getRight();
    }

    public void tearDown() {
    }

    private void closeOutputStream() {
        try {
            this.baos.close();
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_Values_C2.fail(ioe.toString());
        }
    }

    private void openOutputStream() {
        try {
            this.baos = new ByteArrayOutputStream();
            this.oos = new ObjectOutputStream(this.baos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            TEST_ObjectOutputStream_Values_C2.fail("unexpected io exception occurred while setting up");
        }
    }

    public void closeInputStream() {
        try {
            this.bais.close();
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_Values_C2.fail("IO Exception while closing input stream");
        }
    }

    private void openInputStream(byte[] data) {
        try {
            this.bais = new ByteArrayInputStream(data);
            this.ois = new ObjectInputStream(this.bais);
        }
        catch (IOException ioe) {
            TEST_ObjectOutputStream_Values_C2.fail("openStream> " + ioe.toString());
            return;
        }
    }

    protected void runTest() {
        TEST_ObjectOutputStream_Values_C2.assertEquals(this.check.getTestByte(), this.original.getTestByte());
        TEST_ObjectOutputStream_Values_C2.assertEquals(this.check.getTestInt(), this.original.getTestInt());
        TEST_ObjectOutputStream_Values_C2.assertEquals(this.check.getTestFloat(), this.original.getTestFloat(), 1.0E-6);
        TEST_ObjectOutputStream_Values_C2.assertEquals(this.check.getTestChar(), this.original.getTestChar());
        TEST_ObjectOutputStream_Values_C2.assertEquals(this.check.getTestShort(), this.original.getTestShort());
        TEST_ObjectOutputStream_Values_C2.assertEquals(this.check.getTestLong(), this.original.getTestLong());
        TEST_ObjectOutputStream_Values_C2.assertEquals(this.check.getTestDouble(), this.original.getTestDouble(), 1.0E-6);
        TEST_ObjectOutputStream_Values_C2.assert("boolean values are not equal", this.check.getTestBoolean() == this.original.getTestBoolean());
        TEST_ObjectOutputStream_Values_C2.assert(this.check.getTransientInt() == 0);
        TEST_ObjectOutputStream_Values_C2.assertEquals(this.check.getVolatileInt(), this.original.getVolatileInt());
        TEST_ObjectOutputStream_Values_C2.assertEquals(this.check.getD().toString(), this.original.getD().toString());
        TEST_ObjectOutputStream_Values_C2.assertNull(this.check.getTransientD());
    }
}

