/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.Junittests.io;

import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_B;
import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_C;
import gnu.testlet.Junittests.io.SAMPLE_SerialObject;
import gnu.testlet.Mv_Assert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class TEST_ObjectInputStream_Values_C1
extends Mv_Assert {
    private SAMPLE_ObjectStream_C original;
    private SAMPLE_ObjectStream_C check;
    private Object object;
    private ObjectInputStream ois;
    private ByteArrayInputStream bais;
    private byte[] data = new byte[SAMPLE_SerialObject.dataInt.length];
    private static final double DELTA = 1.0E-6;

    public TEST_ObjectInputStream_Values_C1() {
        for (int i = 0; i < SAMPLE_SerialObject.dataInt.length; ++i) {
            this.data[i] = (byte)SAMPLE_SerialObject.dataInt[i];
        }
        this.original = (SAMPLE_ObjectStream_C)SAMPLE_SerialObject.getRootObject().getRight();
    }

    public void setUp() {
        this.openStream(this.data);
        try {
            this.object = this.ois.readObject();
        }
        catch (Exception e) {
            TEST_ObjectInputStream_Values_C1.fail(e.toString());
        }
        this.closeStream();
        this.check = (SAMPLE_ObjectStream_C)((SAMPLE_ObjectStream_B)this.object).getRight();
    }

    public void tearDown() {
    }

    public void closeStream() {
        try {
            this.bais.close();
        }
        catch (IOException ioe) {
            TEST_ObjectInputStream_Values_C1.fail("IO Exception while closing input stream");
        }
    }

    private void openStream(byte[] data) {
        try {
            this.bais = new ByteArrayInputStream(data);
            this.ois = new ObjectInputStream(this.bais);
        }
        catch (IOException ioe) {
            TEST_ObjectInputStream_Values_C1.fail("openStream> " + ioe.toString());
            return;
        }
    }

    protected void runTest() {
        TEST_ObjectInputStream_Values_C1.assertEquals(this.check.getTestByte(), this.original.getTestByte());
        TEST_ObjectInputStream_Values_C1.assertEquals(this.check.getTestInt(), this.original.getTestInt());
        TEST_ObjectInputStream_Values_C1.assertEquals(this.check.getTestFloat(), this.original.getTestFloat(), 1.0E-6);
        TEST_ObjectInputStream_Values_C1.assertEquals(this.check.getTestChar(), this.original.getTestChar());
        TEST_ObjectInputStream_Values_C1.assertEquals(this.check.getTestShort(), this.original.getTestShort());
        TEST_ObjectInputStream_Values_C1.assertEquals(this.check.getTestLong(), this.original.getTestLong());
        TEST_ObjectInputStream_Values_C1.assertEquals(this.check.getTestDouble(), this.original.getTestDouble(), 1.0E-6);
        TEST_ObjectInputStream_Values_C1.assert("boolean values are not equal", this.check.getTestBoolean() == this.original.getTestBoolean());
        TEST_ObjectInputStream_Values_C1.assert(this.check.getTransientInt() == 0);
        TEST_ObjectInputStream_Values_C1.assertEquals(this.check.getVolatileInt(), this.original.getVolatileInt());
        TEST_ObjectInputStream_Values_C1.assertEquals(this.check.getD().toString(), this.original.getD().toString());
        TEST_ObjectInputStream_Values_C1.assertNull(this.check.getTransientD());
    }
}

