/*
 * Decompiled with CFR 0.152.
 */
package wonka.vm;

public class IntHashtable {
    private static final float DEFAULT_LOADFACTOR = 0.75f;
    private static final int DEFAULT_CAPACITY = 101;
    private int capacity;
    private float loadFactor;
    private int occupancy;
    private int threshold;
    private int[] keys;
    private Object[] value;

    public int size() {
        return this.occupancy;
    }

    public Object get(int key) {
        int cap = this.capacity;
        int i = key % cap;
        int[] k = this.keys;
        while (true) {
            int ckey;
            if (i < 0) {
                i += cap;
            }
            if ((ckey = k[i]) == 0) {
                return null;
            }
            if (key == ckey) {
                return this.value[i];
            }
            --i;
        }
    }

    public Object put(int key, Object newvalue) {
        int cap = this.capacity;
        int i = key % cap;
        int[] k = this.keys;
        while (true) {
            int ckey;
            if (i < 0) {
                i += cap;
            }
            if ((ckey = k[i]) == 0) {
                k[i] = key;
                this.value[i] = newvalue;
                if (++this.occupancy >= this.threshold) {
                    this.resize();
                }
                return null;
            }
            if (key == ckey) {
                Object oldvalue = this.value[i];
                this.value[i] = newvalue;
                return oldvalue;
            }
            --i;
        }
    }

    public Object remove(int key) {
        int cap = this.capacity;
        int i = key % cap;
        int[] k = this.keys;
        while (true) {
            int ckey;
            if (i < 0) {
                i += cap;
            }
            if ((ckey = k[i]) == 0) {
                return null;
            }
            if (key == ckey) {
                Object oldvalue = this.value[i];
                this.deleteSlot(i);
                return oldvalue;
            }
            --i;
        }
    }

    public void clear() {
        if (this.occupancy > 0) {
            this.keys = new int[this.capacity];
            this.value = new Object[this.capacity];
            this.occupancy = 0;
        }
    }

    private final int firstBusySlot(int i) {
        if (i < 0 || i >= this.capacity || this.keys == null) {
            return -1;
        }
        int j = i;
        while (j < this.capacity) {
            if (this.keys[j] != 0) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private final int checkSize(int direction) {
        float targetsquared = this.loadFactor * this.loadFactor;
        float current = (float)this.occupancy / (float)this.capacity;
        float currentsquared = current * current;
        if (direction >= 0 && currentsquared < this.loadFactor || direction <= 0 && targetsquared > current) {
            return 0;
        }
        int newsize = (int)((float)this.occupancy / this.loadFactor);
        if (newsize < this.occupancy + 2) {
            newsize = this.occupancy + 2;
        }
        if (direction >= 0 && newsize <= this.capacity) {
            newsize = 0;
        }
        if (direction <= 0 && newsize >= this.capacity) {
            newsize = 0;
        }
        return newsize;
    }

    private final void resize() {
        int oldsize = this.capacity;
        int newsize = oldsize * 2 + 1;
        int[] oldkeys = this.keys;
        Object[] oldvalues = this.value;
        int[] newkeys = new int[newsize];
        Object[] newvalues = new Object[newsize];
        this.capacity = newsize;
        this.occupancy = 0;
        this.keys = newkeys;
        this.value = newvalues;
        this.threshold = (int)(this.loadFactor * (float)newsize);
        int oldindex = 0;
        while (oldindex < oldsize) {
            int key = oldkeys[oldindex];
            if (key != 0) {
                this.put(key, oldvalues[oldindex]);
            }
            ++oldindex;
        }
    }

    private final void deleteSlot(int slotIndex) {
        --this.occupancy;
        int current = slotIndex;
        while (true) {
            this.keys[current] = 0;
            int vacant = current;
            boolean happy = true;
            while (happy) {
                int n = current = current == 0 ? this.capacity - 1 : current - 1;
                if (this.keys[current] == 0) {
                    return;
                }
                int home = this.keys[current] % this.capacity;
                if (home < 0) {
                    home += this.capacity;
                }
                int distance1 = current <= home ? home - current : this.capacity + home - current;
                int distance2 = current <= vacant ? vacant - current : this.capacity + vacant - current;
                boolean bl = false;
                if (distance1 >= distance2) continue;
                bl = happy = true;
            }
            this.keys[vacant] = this.keys[current];
            this.value[vacant] = this.value[current];
        }
    }

    public IntHashtable() {
        this(101, 0.75f);
    }

    public IntHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("IntHashtable needs positive numbers");
        }
        this.capacity = initialCapacity < 5 ? 5 : initialCapacity;
        this.keys = new int[this.capacity];
        this.value = new Object[this.capacity];
        this.loadFactor = loadFactor > 1.0f ? 0.75f : loadFactor;
        this.threshold = (int)(this.loadFactor * (float)this.capacity);
    }
}

