/*
 * Decompiled with CFR 0.152.
 */
package wonka.decoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import wonka.decoders.Decoder;

public class UTF16Decoder
extends Decoder {
    private static final int UNDEFINED = 0;
    private static final int BIGEND = 1;
    private static final int LITTLEEND = 2;
    private int state;

    private final void setEndianness(InputStream in) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        if (b1 == 254 && b2 == 255) {
            this.state = 1;
        } else if (b1 == 255 && b2 == 254) {
            this.state = 2;
        } else {
            throw new UTFDataFormatException("missing BOM");
        }
    }

    public char[] bToC(byte[] bytes, int off, int len) {
        if (len < 2) {
            throw new IllegalArgumentException();
        }
        int l = len / 2 - 1;
        char[] chars = new char[l];
        int c = bytes[off++];
        if ((c = (c << 8 | bytes[off++] & 0xFF) & (char)-1) == 65534) {
            int i = 0;
            while (i < l) {
                int ch = bytes[off++] & 0xFF;
                chars[i] = (char)((ch | bytes[off++] << 8) & (char)-1);
                ++i;
            }
        } else if (c == 65279) {
            int i = 0;
            while (i < l) {
                int ch = bytes[off++] << 8;
                chars[i] = (char)((ch | bytes[off++] & 0xFF) & (char)-1);
                ++i;
            }
        } else {
            throw new IllegalArgumentException("no valid UTF16 bytes: '" + (char)c + "' = " + Integer.toHexString(c));
        }
        return chars;
    }

    /*
     * Unable to fully structure code
     */
    public int cFromStream(InputStream in, char[] chars, int off, int len) throws IOException {
        block7: {
            if (this.state == 0) {
                this.setEndianness(in);
            }
            if ((rd = in.read(bytes = new byte[l = 2 * len], 0, l)) == -1) {
                return -1;
            }
            if (rd % 2 == 1) {
                b = in.read();
                if (b != -1) {
                    bytes[rd++] = (byte)b;
                } else {
                    --rd;
                }
            }
            i = 0;
            if (this.state != 1) ** GOTO lbl20
            while (i < rd) {
                ch = bytes[i++] << 8;
                chars[off++] = (char)((ch | bytes[i++] & 255) & (char)-1);
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                ch = bytes[i++] & 255;
                chars[off++] = (char)((ch | bytes[i++] << 8) & (char)-1);
lbl20:
                // 2 sources

                ** while (i < rd)
            }
        }
        return rd / 2;
    }

    public byte[] cToB(char[] chars, int off, int len) {
        byte[] bytes = new byte[len * 2 + 2];
        len += off;
        bytes[0] = -2;
        bytes[1] = -1;
        int o = 2;
        int i = off;
        while (i < len) {
            char ch = chars[i];
            bytes[o++] = (byte)(ch >> 8);
            bytes[o++] = (byte)ch;
            ++i;
        }
        return bytes;
    }

    public int getChar(InputStream in) throws IOException {
        int b1;
        if (this.state == 0) {
            this.setEndianness(in);
        }
        if ((b1 = in.read()) == -1) {
            return -1;
        }
        int b2 = in.read();
        if (b2 == -1) {
            return -1;
        }
        if (this.state == 1) {
            return b1 << 8 | b2;
        }
        return b2 << 8 | b1;
    }

    public String getEncoding() {
        return "UTF16";
    }
}

