/*
 * Decompiled with CFR 0.152.
 */
package wonka.decoders;

import java.io.IOException;
import java.io.InputStream;
import wonka.decoders.Decoder;

public class UTF16BeDecoder
extends Decoder {
    public char[] bToC(byte[] bytes, int off, int len) {
        int l = len / 2;
        char[] chars = new char[l];
        int i = 0;
        while (i < l) {
            int ch = bytes[off++] << 8;
            chars[i] = (char)((ch | bytes[off++] & 0xFF) & (char)-1);
            ++i;
        }
        return chars;
    }

    public int cFromStream(InputStream in, char[] chars, int off, int len) throws IOException {
        int l = 2 * len;
        byte[] bytes = new byte[l];
        int rd = in.read(bytes, 0, l);
        if (rd == -1) {
            return -1;
        }
        if (rd % 2 == 1) {
            int b = in.read();
            if (b != -1) {
                bytes[rd++] = (byte)b;
            } else {
                --rd;
            }
        }
        int i = 0;
        while (i < rd) {
            int ch = bytes[i++] << 8;
            chars[off++] = (char)((ch | bytes[i++] & 0xFF) & (char)-1);
        }
        return rd / 2;
    }

    public byte[] cToB(char[] chars, int off, int len) {
        byte[] bytes = new byte[2 * len];
        len += off;
        int o = 0;
        int i = off;
        while (i < len) {
            char ch = chars[i];
            bytes[o++] = (byte)(ch >> 8);
            bytes[o++] = (byte)ch;
            ++i;
        }
        return bytes;
    }

    public int getChar(InputStream in) throws IOException {
        int b1 = in.read();
        if (b1 == -1) {
            return -1;
        }
        int b2 = in.read();
        if (b2 == -1) {
            return -1;
        }
        return b2 | b1 << 8;
    }

    public String getEncoding() {
        return "UTF-16BE";
    }
}

