/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static final byte last = ZipConstants.endCenDirS[3];
    private RandomAccessFile raf;
    private String name;
    private boolean isJar;
    private int nrEntries;
    String[] strings;
    long[] longs;
    int capacity;

    private ZipEntry newZipEntry(String name) {
        if (this.isJar) {
            return new JarEntry(name);
        }
        return new ZipEntry(name);
    }

    public ZipFile(String name) throws IOException {
        try {
            this.isJar = Class.forName("java.util.jar.JarFile").isInstance(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.name = name;
        this.raf = new RandomAccessFile(name, "r");
        this.getEntries();
        if (this.strings == null) {
            throw new ZipException("Bad or No ZipFile ");
        }
    }

    public ZipFile(File file) throws ZipException, IOException {
        try {
            this.isJar = Class.forName("java.util.jar.JarFile").isInstance(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.name = file.getName();
        this.raf = new RandomAccessFile(file, "r");
        this.getEntries();
        if (this.strings == null) {
            throw new ZipException("Bad or No ZipFile ");
        }
    }

    public ZipFile(File file, int mode) throws ZipException, IOException {
        this(file);
        if (mode == 4) {
            throw new IllegalArgumentException("OPEN_DELELTE: Unsupported feature");
        }
    }

    public void close() throws IOException {
        this.nrEntries = 0;
        this.capacity = 1;
        this.strings = new String[1];
        this.longs = null;
    }

    public Enumeration entries() {
        return new Enum();
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public ZipEntry getEntry(String zname) {
        int hash = zname.hashCode() % this.capacity;
        while (true) {
            if (hash < 0) {
                hash += this.capacity;
            }
            if (this.strings[hash] == null) {
                return null;
            }
            if (zname.equals(this.strings[hash])) break;
            --hash;
        }
        try {
            return this.createEntry(this.longs[hash]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream(ZipEntry ze) throws IOException {
        if (ze.zipFile != this) {
            throw new IOException("entry doesn't not belong to this file");
        }
        return new ByteArrayInputStream(this.checkHeader(ze));
    }

    public int size() {
        return this.nrEntries;
    }

    private void getEntries() throws IOException {
        long pos = this.raf.length();
        int size = 1024L > pos ? (int)pos : 1024;
        byte[] bytes = new byte[size];
        while (pos > 0L) {
            this.raf.seek(pos -= (long)size);
            this.raf.readFully(bytes, 0, size);
            size = this.locateEndCD(bytes, size);
            if (size == -1) break;
            if (size > 0) {
                System.arraycopy(bytes, 0, bytes, bytes.length - size, size);
            }
            size = (1024L > pos ? (int)pos : 1024) - size;
        }
    }

    private int locateEndCD(byte[] bytes, int size) throws IOException {
        int p = size;
        while (--p > -1) {
            if (bytes[p] != last) continue;
            if (p >= 3) {
                if (bytes[p - 1] != ZipConstants.endCenDirS[2] || bytes[p - 2] != ZipConstants.endCenDirS[1] || bytes[p - 3] != ZipConstants.endCenDirS[0] || !this.readEntries(bytes, size, p + 1)) continue;
                return -1;
            }
            return p;
        }
        return 0;
    }

    private boolean readEntries(byte[] bytes, int size, int pos) throws IOException {
        int capacity;
        int nrE = size - pos;
        nrE = 16 > nrE ? nrE : 16;
        byte[] b = new byte[16];
        System.arraycopy(bytes, pos, b, 0, nrE);
        if (nrE < 16) {
            this.raf.readFully(b, nrE, 16 - nrE);
        }
        nrE = (0xFF & (char)b[6]) + (0xFF & (char)b[7]) * 256;
        long stP = ZipFile.bytesToLong(b, 12);
        size = (int)ZipFile.bytesToLong(b, 8);
        if (nrE < 0 || stP + (long)size > this.raf.length() || size < 0) {
            return false;
        }
        this.raf.seek(stP);
        b = new byte[size];
        this.raf.readFully(b);
        pos = 0;
        this.capacity = capacity = (int)((float)nrE / 0.74f) + 1;
        this.strings = new String[capacity];
        this.longs = new long[capacity];
        for (int i = 0; i < nrE; ++i) {
            int hlp;
            int len;
            if (pos + 46 > size) {
                throw new ZipException("to little bytes for header");
            }
            if (ZipConstants.cenFileHeaderS[0] != b[pos] || ZipConstants.cenFileHeaderS[1] != b[pos + 1] || ZipConstants.cenFileHeaderS[2] != b[pos + 2] || ZipConstants.cenFileHeaderS[3] != b[pos + 3]) {
                throw new ZipException("bad header in central file directory");
            }
            long pointer = stP + (long)pos;
            pos += 28;
            if ((pos += 18) + (len = (0xFF & (char)b[pos]) + (0xFF & (char)b[pos + 1]) * 256) > size) {
                throw new ZipException("not enough bytes in header");
            }
            String name = new String(b, pos, len);
            if ((hlp = (0xFF & (char)b[pos -= 36]) + (0xFF & (char)b[pos + 1]) * 256) != 0 && hlp != 8) {
                throw new ZipException("unknown store/zip method " + hlp);
            }
            hlp = (0xFF & (char)b[pos += 20]) + (0xFF & (char)b[pos + 1]) * 256;
            int com = (0xFF & (char)b[pos += 2]) + (0xFF & (char)b[pos + 1]) * 256;
            if (hlp < 0 || com < 0 || pos + 14 + len + hlp + com > size) {
                throw new ZipException("invalid header data");
            }
            pos += 10;
            int hashcode = name.hashCode() % capacity;
            while (true) {
                if (hashcode < 0) {
                    hashcode += capacity;
                }
                if (this.strings[hashcode] == null) break;
                if (name.equals(this.strings[hashcode])) {
                    throw new IOException("duplicate entry found " + name);
                }
                --hashcode;
            }
            this.strings[hashcode] = name;
            this.longs[hashcode] = pointer;
            pos += 4 + len;
            if (hlp > 0) {
                pos += hlp;
            }
            if (com <= 0) continue;
            pos += com;
        }
        this.nrEntries = nrE;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] checkHeader(ZipEntry ze) throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(ze.pointer);
            byte[] header = new byte[30];
            this.raf.readFully(header, 0, 30);
            if (header[0] != ZipConstants.locFileHeaderS[0] || header[1] != ZipConstants.locFileHeaderS[1] || header[2] != ZipConstants.locFileHeaderS[2] || header[3] != ZipConstants.locFileHeaderS[3]) {
                throw new ZipException("corrupt header found");
            }
            int mode = (0xFF & (char)header[4]) + (0xFF & (char)header[5]) * 256;
            if (mode > 20) {
                throw new ZipException("higher zip version needed");
            }
            mode = 8 & header[6];
            int fnlen = (0xFF & header[26]) + (0xFF & header[27]) * 256;
            byte[] fname = new byte[fnlen];
            this.raf.readFully(fname, 0, fnlen);
            String name = new String(fname, 0, fnlen);
            if (!ze.name.equals(name)) {
                throw new ZipException("entry pointed to wrong data");
            }
            fnlen = (0xFF & (char)header[28]) + (0xFF & (char)header[29]) * 256;
            fname = new byte[fnlen];
            if (fnlen != 0) {
                this.raf.readFully(fname, 0, fnlen);
            }
            if ((mode = (0xFF & (char)header[8]) + (0xFF & (char)header[9]) * 256) != 8 && mode != 0) {
                throw new ZipException("stream is corrupted");
            }
            if (mode == 8) {
                header = new byte[(int)ze.compressedSize];
                this.raf.readFully(header);
                header = this.quickInflate(header, (int)ze.size, (int)ze.crc);
            } else {
                header = new byte[(int)ze.size];
                this.raf.readFully(header);
            }
            return header;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipEntry createEntry(long entry) throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(entry);
            int pos = 0;
            byte[] b = new byte[46];
            this.raf.readFully(b);
            if (ZipConstants.cenFileHeaderS[0] != b[pos] || ZipConstants.cenFileHeaderS[1] != b[pos + 1] || ZipConstants.cenFileHeaderS[2] != b[pos + 2] || ZipConstants.cenFileHeaderS[3] != b[pos + 3]) {
                throw new ZipException("bad header in central file directory");
            }
            int len = (0xFF & (char)b[pos += 28]) + (0xFF & (char)b[pos + 1]) * 256;
            pos += 18;
            byte[] name = new byte[len];
            this.raf.readFully(name);
            ZipEntry ze = this.newZipEntry(new String(name));
            int hlp = (0xFF & (char)b[pos -= 36]) + (0xFF & (char)b[pos + 1]) * 256;
            if (hlp != 0 && hlp != 8) {
                throw new ZipException("unknown store/zip method " + hlp);
            }
            ze.method = hlp;
            ze.time = ZipFile.getDate(b, pos += 2);
            ze.crc = ZipFile.bytesToLong(b, pos += 4);
            ze.compressedSize = ZipFile.bytesToLong(b, pos += 4);
            ze.size = ZipFile.bytesToLong(b, pos += 4);
            hlp = (0xFF & (char)b[pos += 6]) + (0xFF & (char)b[pos + 1]) * 256;
            int com = (0xFF & (char)b[pos += 2]) + (0xFF & (char)b[pos + 1]) * 256;
            if (hlp < 0 || com < 0) {
                throw new ZipException("invalid header data");
            }
            ze.pointer = ZipFile.bytesToLong(b, pos += 10);
            if (hlp > 0) {
                byte[] extra = new byte[hlp];
                this.raf.readFully(extra);
                ze.extra = extra;
            }
            if (com > 0) {
                byte[] comment = new byte[com];
                this.raf.readFully(comment);
                ze.comment = new String(comment);
            }
            ze.zipFile = this;
            return ze;
        }
    }

    private native byte[] quickInflate(byte[] var1, int var2, int var3) throws ZipException;

    static native long bytesToLong(byte[] var0, int var1);

    static native long getDate(byte[] var0, int var1);

    static {
        new JarEntry("");
    }

    private class Enum
    implements Enumeration {
        int index = -1;

        Enum() {
            for (int i = 0; i < ZipFile.this.capacity; ++i) {
                if (ZipFile.this.strings[i] == null) continue;
                this.index = i;
                break;
            }
        }

        public boolean hasMoreElements() {
            return this.index != -1;
        }

        public Object nextElement() {
            if (this.index == -1) {
                throw new NoSuchElementException();
            }
            long l = ZipFile.this.longs[this.index];
            this.index = -1;
            for (int i = this.index + 1; i < ZipFile.this.capacity; ++i) {
                if (ZipFile.this.strings[i] == null) continue;
                this.index = i;
                break;
            }
            try {
                return ZipFile.this.createEntry(l);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

