/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Adler32;
import java.util.zip.DataFormatException;
import java.util.zip.ZipFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Inflater {
    private Adler32 adler;
    private boolean finished;
    private boolean needsInput;
    private boolean needsDict;
    private boolean noHeader;
    private boolean skip;
    private int totalIn;
    private int totalOut;
    private int remain;
    private byte[] header;
    private int dictAdler;

    public int inflate(byte[] buf) throws DataFormatException {
        return this.inflate(buf, 0, buf.length);
    }

    public void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length);
    }

    public void setDictionary(byte[] buf) {
        this.setDictionary(buf, 0, buf.length);
    }

    public synchronized int getAdler() {
        return this.dictAdler == 0 ? (int)this.adler.getValue() : this.dictAdler;
    }

    public synchronized boolean needsDictionary() {
        return this.needsDict;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized boolean needsInput() {
        return this.needsInput;
    }

    public synchronized int getTotalIn() {
        return this.totalIn;
    }

    public synchronized int getTotalOut() {
        return this.totalOut;
    }

    public synchronized int inflate(byte[] buf, int off, int len) throws DataFormatException {
        if (this.finished) {
            return 0;
        }
        len = this._inflate(buf, off, len);
        this.adler.update(buf, off, len);
        this.totalOut += len;
        return len;
    }

    public synchronized void setInput(byte[] buf, int off, int len) {
        if (off < 0 || len < 0 || buf.length < off + len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len != 0) {
            if (this.skip) {
                int put = (6 > len ? len : 6) - this.totalIn;
                System.arraycopy(buf, off, this.header, this.totalIn, put);
                this.totalIn += len;
                if (this.totalIn >= 6) {
                    if ((this.header[1] & 0x20) != 1) {
                        this._setInput(this.header, 2, 4);
                        this.remain = 6;
                    } else {
                        this.dictAdler = (int)ZipFile.bytesToLong(this.header, 2);
                        this.remain = 10;
                    }
                    this._setInput(buf, off + put, len - put);
                    this.skip = false;
                    this.header = null;
                }
            } else {
                this.totalIn += len;
                this._setInput(buf, off, len);
            }
            this.needsInput = false;
        }
    }

    public synchronized void reset() {
        this.needsInput = true;
        this.finished = false;
        this.needsDict = false;
        this.totalIn = 0;
        this.totalOut = 0;
        this.dictAdler = 0;
        this.adler.reset();
        this.nativeReset();
    }

    protected native void finalize();

    private final native void nativeReset();

    private final native void create();

    private final native int _inflate(byte[] var1, int var2, int var3) throws DataFormatException;

    private final native void _setInput(byte[] var1, int var2, int var3);

    public synchronized native void end();

    public synchronized native void setDictionary(byte[] var1, int var2, int var3);

    public synchronized native int getRemaining();

    private final /* synthetic */ void this() {
        this.adler = new Adler32();
        this.finished = false;
        this.needsInput = true;
        this.needsDict = false;
        this.totalIn = 0;
        this.totalOut = 0;
        this.remain = 0;
        this.dictAdler = 0;
    }

    public Inflater() {
        this(false);
    }

    public Inflater(boolean noHeader) {
        this.this();
        this.create();
        this.noHeader = noHeader;
        this.skip = noHeader ^ true;
        if (this.skip) {
            this.header = new byte[6];
        }
    }
}

