/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeflaterOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected Deflater def;
    private boolean finished;

    protected void deflate() throws IOException {
        if (this.finished) {
            throw new IOException("stream has finished");
        }
        int used = 0;
        int size = this.buf.length;
        while (!this.def.needsInput()) {
            if (size == used) {
                this.out.write(this.buf, 0, size);
                used = 0;
            }
            used += this.def.deflate(this.buf, used, size - used);
        }
        this.out.write(this.buf, 0, used);
        used = 0;
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.def.finish();
            this.deflate();
            this.finished = true;
        }
    }

    public void write(int bval) throws IOException {
        byte[] b = new byte[]{(byte)bval};
        this.write(b, 0, 1);
    }

    public void write(byte[] buffer, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || buffer.length < offset + len) {
            throw new IndexOutOfBoundsException();
        }
        this.deflate();
        this.def.setInput(buffer, offset, len);
    }

    private final /* synthetic */ void this() {
        this.finished = false;
    }

    public DeflaterOutputStream(OutputStream out) {
        this(out, new Deflater(), 512);
    }

    public DeflaterOutputStream(OutputStream out, Deflater defl) {
        this(out, defl, 512);
    }

    public DeflaterOutputStream(OutputStream out, Deflater defl, int bufsize) {
        super(out);
        this.this();
        if (defl == null) {
            throw new NullPointerException();
        }
        this.def = defl;
        this.buf = new byte[bufsize];
    }
}

