/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;

class TimerThread
extends Thread
implements Comparator {
    private TreeSet tasks;
    boolean cancelled;
    boolean waiting;
    long waitTime;
    private WeakReference timerReference;

    public int compare(Object o, Object t) {
        if (o == t) {
            return 0;
        }
        return ((TimerTask)o).startTime < ((TimerTask)t).startTime ? -1 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (true) {
            block18: {
                block17: {
                    long l;
                    long l2;
                    long time;
                    TimerTask task;
                    TimerThread timerThread = this;
                    // MONITORENTER : timerThread
                    {
                        try {
                            if (this.cancelled) {
                                // MONITOREXIT : timerThread
                                return;
                            }
                            if (this.tasks.isEmpty()) {
                                if (this.timerReference.get() != null) {
                                    this.waiting = true;
                                    this.wait(1000L);
                                    this.waiting = false;
                                } else {
                                    this.cancelled = true;
                                }
                                // MONITOREXIT : timerThread
                                continue;
                            }
                            task = (TimerTask)this.tasks.first();
                            if (task.cancelled) {
                                this.tasks.remove(task);
                                // MONITOREXIT : timerThread
                                continue;
                            }
                            time = System.currentTimeMillis();
                            if (time < task.startTime) {
                                this.waiting = true;
                                this.wait(task.startTime - time);
                                this.waiting = false;
                                // MONITOREXIT : timerThread
                                continue;
                            }
                            this.tasks.remove(task);
                        }
                        catch (InterruptedException ie) {
                            this.waiting = false;
                            // MONITOREXIT : timerThread
                            continue;
                        }
                        task.run();
                    }
                    timerThread = this;
                    // MONITORENTER : timerThread
                    if (task.period != (long)-1 && !task.cancelled) {
                        l2 = task.period;
                        l = task.fixed ? task.startTime : time;
                    }
                    break block17;
                    task.startTime = l2 + l;
                    this.tasks.add(task);
                    break block18;
                }
                task.cancelled = true;
            }
            // MONITOREXIT : timerThread
        }
    }

    void schedule(TimerTask task, long delay, long period, boolean fixedRate) {
        if (delay < 0L) {
            throw new IllegalArgumentException("negative delay is not allowed");
        }
        this.scheduleAtTime(task, delay + System.currentTimeMillis(), period, fixedRate);
    }

    synchronized void scheduleAtTime(TimerTask task, long time, long period, boolean fixedRate) {
        if (time < 0L) {
            throw new IllegalArgumentException("negative time is not allowed");
        }
        if (task.startTime != (long)-1 || task.cancelled) {
            throw new IllegalStateException("task cannot be scheduled");
        }
        if (this.cancelled || !this.isAlive()) {
            throw new IllegalStateException("timer cannot schedule task " + task);
        }
        task.startTime = time;
        task.period = period;
        task.fixed = fixedRate;
        this.tasks.add(task);
        if (this.waiting) {
            this.notifyAll();
        }
    }

    TimerThread(Timer timer, boolean daemon) {
        super("Thread for timer:" + timer);
        this.timerReference = new WeakReference(timer);
        this.tasks = new TreeSet(this);
        this.setDaemon(daemon);
        this.start();
    }
}

