/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.acunia.resource.TimeZoneResourceBundle;
import java.io.Serializable;
import java.util.Date;
import java.util.GetSystemProperty;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SimpleTimeZone;

public abstract class TimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3581463369166924961L;
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static TimeZone defaultTZ = new SimpleTimeZone(0, "GMT");
    private static TimeZoneResourceBundle tzResBundle;
    private String ID;

    private static synchronized TimeZoneResourceBundle getTimeZoneResourceBundle() {
        if (tzResBundle == null) {
            try {
                tzResBundle = (TimeZoneResourceBundle)ResourceBundle.getBundle("com.acunia.resource.TimeZoneResourceBundle");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tzResBundle;
    }

    public static synchronized void setDefault(TimeZone tz) {
        defaultTZ = tz;
        if (tz == null) {
            defaultTZ = TimeZone.getTimeZoneResourceBundle() != null ? tzResBundle.getTimeZone(GetSystemProperty.DEFAULT_TIMEZONE) : new SimpleTimeZone(0, "GMT");
        }
    }

    public void setID(String newID) {
        if (newID == null) {
            throw new NullPointerException();
        }
        this.ID = newID;
    }

    public String getID() {
        return this.ID;
    }

    public boolean hasSameRules(TimeZone tz) {
        return this.getRawOffset() == tz.getRawOffset() && this.useDaylightTime() == tz.useDaylightTime();
    }

    public String toString() {
        return super.toString() + "ID=" + this.ID;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale loc) {
        return this.getDisplayName(false, 1, loc);
    }

    public final String getDisplayName(boolean daylight, int style) {
        return this.getDisplayName(daylight, style, Locale.getDefault());
    }

    public String getDisplayName(boolean daylight, int style, Locale loc) {
        String[] sa = null;
        int i = 1 + style + (daylight ? 2 : 0);
        String s = null;
        try {
            ResourceBundle tzNames = ResourceBundle.getBundle("com.acunia.resource.TimeZoneDisplayNameResourceBundle", loc);
            sa = tzNames.getStringArray(this.ID);
            s = sa[i];
        }
        catch (Exception e) {
            // empty catch block
        }
        if (s == null) {
            StringBuffer buf = new StringBuffer("GMT");
            int offset = this.getRawOffset();
            if (offset >= 0) {
                buf.append('+');
            } else {
                buf.append('-');
                offset *= -1;
            }
            int h = offset / 3600000;
            buf.append((char)(48 + h / 10));
            buf.append((char)(48 + h % 10));
            buf.append(':');
            h = offset % 3600000 / 60000;
            buf.append((char)(48 + h / 10));
            buf.append((char)(48 + h % 10));
            s = new String(buf);
        }
        return s;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public abstract void setRawOffset(int var1);

    public abstract boolean inDaylightTime(Date var1);

    public abstract boolean useDaylightTime();

    public static synchronized TimeZone getDefault() {
        return defaultTZ;
    }

    public static synchronized TimeZone getTimeZone(String rID) {
        if (TimeZone.getTimeZoneResourceBundle() == null) {
            return null;
        }
        return tzResBundle.getTimeZone(rID);
    }

    public static synchronized String[] getAvailableIDs() {
        if (TimeZone.getTimeZoneResourceBundle() == null) {
            return new String[0];
        }
        return tzResBundle.getKeysArray();
    }

    public static synchronized String[] getAvailableIDs(int rawOffset) {
        if (TimeZone.getTimeZoneResourceBundle() == null) {
            return new String[0];
        }
        return tzResBundle.getKeysArray(rawOffset);
    }
}

