/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.acunia.wonka.security.PropertyPermissionCollection;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;

public final class PropertyPermission
extends BasicPermission {
    private static final long serialVersionUID = 885438825399942851L;
    private String actions;
    private boolean read;
    private boolean write;

    private void parseActions(String s) {
        String sx = s.toLowerCase();
        while (sx != "") {
            String s0;
            int i = sx.indexOf(44);
            if (i < 0) {
                s0 = sx.trim();
                sx = "";
            } else {
                s0 = sx.substring(0, i).trim();
                sx = sx.substring(i + 1);
            }
            if (s0.equals("read")) {
                this.read = true;
                continue;
            }
            if (s0.equals("write")) {
                this.write = true;
                continue;
            }
            throw new IllegalArgumentException("udefined action encountered: " + s0);
        }
        this.actions = this.read ? (this.write ? "read,write" : "read") : "write";
    }

    public PropertyPermission(String path, String actions) {
        super(path);
        this.parseActions(actions);
    }

    public boolean implies(Permission p) {
        try {
            PropertyPermission pp = (PropertyPermission)p;
            if (pp.read && !this.read || pp.write && !this.write) {
                return false;
            }
            String thisname = super.getName();
            String othername = p.getName();
            if (thisname == "*") {
                return true;
            }
            if (thisname.charAt(thisname.length() - 1) == '*') {
                return othername.startsWith(thisname.substring(0, thisname.length() - 1));
            }
            return othername.equals(thisname);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission pp = (PropertyPermission)o;
        if (pp.read != this.read || pp.write != this.write) {
            return false;
        }
        return pp.getName().equals(super.getName());
    }

    public int hashCode() {
        int h = super.getName().hashCode();
        return h;
    }

    public String getActions() {
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }
}

