/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Properties
extends Hashtable {
    private static final String keyValueSeparators = "= :\t\r\n\f";
    private static final String commentChars = "#!";
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;

    public Properties() {
        this(null);
    }

    public Properties(Properties deflts) {
        this.defaults = deflts;
    }

    public String getProperty(String key) {
        String val = (String)this.get(key);
        if (val == null && this.defaults != null) {
            val = this.defaults.getProperty(key);
        }
        return val;
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    private Hashtable flatten() {
        if (this.defaults == null) {
            return (Hashtable)this.clone();
        }
        Hashtable h = this.defaults.flatten();
        h.putAll(this);
        return h;
    }

    public Enumeration propertyNames() {
        return this.flatten().keys();
    }

    private boolean isBrokenLine(String line) {
        char[] str = line.toCharArray();
        int i = str.length - 1;
        int count = 0;
        while (i >= 0 && str[i] == '\\') {
            --i;
            ++count;
        }
        return count % 2 == 1;
    }

    private String ltrim(String s) {
        int i;
        char[] str = s.toCharArray();
        if ("".equals(s)) {
            return s;
        }
        if (!Character.isWhitespace(str[0])) {
            return s;
        }
        int len = s.length();
        for (i = 1; i < len && Character.isWhitespace(str[i]); ++i) {
        }
        if (i == len) {
            return "";
        }
        return s.substring(i);
    }

    /*
     * Unable to fully structure code
     */
    private String getLine(BufferedReader br) throws IOException {
        block12: {
            resultLine = new StringBuffer();
            block7: while (true) {
                if ((line = br.readLine()) == null) {
                    return null;
                }
                if ((line = this.ltrim(line)).equals("")) continue;
                if ("#!".indexOf(line.charAt(0), 0) == -1) break block12;
                do {
                    if (this.isBrokenLine(line)) ** break;
                    continue block7;
                } while ((line = br.readLine()) != null);
                break;
            }
            return null;
        }
        while (this.isBrokenLine(line)) {
            resultLine.append(line.substring(0, line.length() - 1));
            line = br.readLine();
            line = line == null ? "" : this.ltrim(line);
        }
        resultLine.append(line);
        source = resultLine.toString();
        lastIndex = 0;
        while ((index = source.indexOf(92, lastIndex)) != -1) {
            switch (source.charAt(index + 1)) {
                case '\\': {
                    c = "\\";
                    break;
                }
                case 'n': {
                    c = "\n";
                    break;
                }
                case 'r': {
                    c = "\r";
                    break;
                }
                case 't': {
                    c = "\t";
                    break;
                }
                case 'f': {
                    c = "\f";
                    break;
                }
                default: {
                    c = "\\" + source.charAt(index + 1);
                }
            }
            source = source.substring(0, index) + c + source.substring(index + 2, source.length());
            lastIndex = index + 1;
        }
        return source;
    }

    public void load(InputStream inStream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "8859_1"));
        String line;
        while ((line = this.getLine(br)) != null) {
            int len = line.length();
            boolean gotIt = false;
            int index = len;
            int seplen = keyValueSeparators.length();
            boolean backSlash = false;
            for (int i = 0; i < len; ++i) {
                char c = line.charAt(i);
                if (c == '\\') {
                    backSlash = true;
                    ++i;
                    continue;
                }
                if (keyValueSeparators.indexOf(c) == -1) continue;
                index = i;
                break;
            }
            if (index != len) {
                String key = line.substring(0, index).trim();
                String value = "";
                if (index < len - 1 && (value = this.ltrim(line.substring(index + 1, len))).length() > 0 && (value.charAt(0) == '=' || value.charAt(0) == ':')) {
                    value = this.ltrim(value.substring(1, value.length()));
                }
                if (backSlash) {
                    key = this.removeSlashes(key);
                }
                this.put(key, value);
                continue;
            }
            if (backSlash) {
                line = this.removeSlashes(line);
            }
            this.put(line, "");
        }
        return;
    }

    private String removeSlashes(String slashed) {
        int i = slashed.indexOf(92);
        StringBuffer result = new StringBuffer(128);
        result.append(slashed.substring(0, i));
        int j = slashed.indexOf(92, ++i);
        while (j != -1) {
            if (i == j) {
                result.append('\\');
            } else {
                result.append(slashed.substring(i, j));
                i = j;
            }
            j = slashed.indexOf(92, ++i);
        }
        result.append(slashed.substring(i));
        return result.toString();
    }

    public synchronized void save(OutputStream out, String header) {
        try {
            this.store(out, header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        BufferedWriter bout = new BufferedWriter(new OutputStreamWriter(out));
        if (header != null) {
            bout.write("#" + header + '\n');
        }
        bout.write("#" + new Date().toString() + '\n');
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = (String)this.get(key);
            bout.write(this.addSlashes(key) + "=" + value + '\n');
        }
        bout.flush();
    }

    private String addSlashes(String key) {
        int len = key.length();
        StringBuffer result = new StringBuffer(len + 5);
        for (int i = 0; i < len; ++i) {
            char c = key.charAt(i);
            if (c == '\\' || keyValueSeparators.indexOf(c) != -1) {
                result.append('\\');
            }
            result.append(c);
        }
        return result.toString();
    }

    public void list(PrintStream out) throws NullPointerException {
        if (out == null) {
            throw new NullPointerException();
        }
        Hashtable h = this.flatten();
        Enumeration enumeration = h.keys();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            String key = (String)o;
            String value = (String)h.get(key);
            if (value.length() > 40) {
                value = value.substring(0, 37) + "...";
            }
            out.println(key + "=" + value);
        }
    }

    public void list(PrintWriter out) throws NullPointerException {
        Hashtable h = this.flatten();
        Enumeration enumeration = h.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = (String)h.get(key);
            if (value.length() > 40) {
                value = value.substring(0, 37) + "...";
            }
            out.println(key + "=" + value);
        }
    }
}

