/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.acunia.resource.LocaleResourceManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Locale
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9149081749638150636L;
    private String language;
    private String country;
    private String variant;
    private static ResourceBundle ISO3Languages = null;
    private static ResourceBundle ISO3Countries = null;
    private static LocaleResourceManager locResManager = new LocaleResourceManager();
    public static final Locale WONDERFUL_WORLD_OF_WONKA;
    private static Locale defaultLoc;
    public static final Locale BELGIUM;
    public static final Locale DUTCH;
    public static final Locale CANADA;
    public static final Locale CHINA;
    public static final Locale FRANCE;
    public static final Locale GERMANY;
    public static final Locale ITALY;
    public static final Locale JAPAN;
    public static final Locale KOREA;
    public static final Locale PRC;
    public static final Locale UK;
    public static final Locale US;
    public static final Locale TAIWAN;
    public static final Locale CANADA_FRENCH;
    public static final Locale CHINESE;
    public static final Locale ENGLISH;
    public static final Locale GERMAN;
    public static final Locale FRENCH;
    public static final Locale ITALIAN;
    public static final Locale JAPANESE;
    public static final Locale KOREAN;
    public static final Locale SIMPLIFIED_CHINESE;
    public static final Locale TRADITIONAL_CHINESE;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.language = (String)in.readObject();
        this.country = (String)in.readObject();
        this.variant = (String)in.readObject();
        in.readInt();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.language);
        out.writeObject(this.country);
        out.writeObject(this.variant);
        out.writeInt(-1);
    }

    public Locale(String l, String c) {
        this(l, c, "");
    }

    private Locale(String l, String c, String v, int i) {
        this.language = l;
        this.country = c;
        this.variant = v;
    }

    public Locale(String l, String c, String v) {
        String[] values = locResManager.checkValues(l, c, v);
        this.language = values[0];
        this.country = values[1];
        this.variant = values[2];
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getVariant() {
        return this.variant;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.language);
        if (!"".equals(this.country)) {
            result.append('_');
            result.append(this.country);
            if (!"".equals(this.variant)) {
                result.append('_');
                result.append(this.variant);
            }
        }
        return new String(result);
    }

    public Object clone() {
        return new Locale(this.language, this.country, this.variant);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Locale)) {
            return false;
        }
        Locale l = (Locale)o;
        return this.language.equals(l.getLanguage()) && this.country.equals(l.getCountry()) && this.variant.equals(l.getVariant());
    }

    public int hashCode() {
        return this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
    }

    public String getISO3Language() throws MissingResourceException {
        if (ISO3Languages == null) {
            ISO3Languages = ResourceBundle.getBundle("com.acunia.resource.ISO3166languageResourceBundle");
        }
        return ISO3Languages.getString(this.language);
    }

    public String getISO3Country() throws MissingResourceException {
        if (ISO3Countries == null) {
            ISO3Countries = ResourceBundle.getBundle("com.acunia.resource.ISO3166countryResourceBundle");
        }
        return ISO3Countries.getString(this.country);
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale inLocale) {
        ResourceBundle displayProps = ResourceBundle.getBundle("com.acunia.resource.LocaleDisplayCountryResourceBundle", inLocale);
        String s = this.country;
        try {
            s = displayProps.getString(this.country);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        return s;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale inLocale) {
        ResourceBundle displayProps = ResourceBundle.getBundle("com.acunia.resource.LocaleDisplayLanguageResourceBundle", inLocale);
        String s = this.language;
        try {
            s = displayProps.getString(s);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        return s;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale inLocale) {
        ResourceBundle displayProps = ResourceBundle.getBundle("com.acunia.resource.LocaleDisplayVariantResourceBundle", inLocale);
        String s = this.variant;
        try {
            s = displayProps.getString(s);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        return s;
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale inLocale) {
        if (this.country.equals("")) {
            return this.getDisplayLanguage(inLocale);
        }
        StringBuffer buf = new StringBuffer(this.getDisplayLanguage(inLocale));
        buf.append('(');
        buf.append(this.getDisplayCountry(inLocale));
        if (!this.variant.equals("")) {
            buf.append(',');
            buf.append(this.getDisplayVariant(inLocale));
        }
        buf.append(')');
        return new String(buf);
    }

    public static synchronized Locale getDefault() {
        return defaultLoc;
    }

    public static synchronized void setDefault(Locale defLoc) {
        if (defLoc == null) {
            throw new NullPointerException();
        }
        defaultLoc = defLoc;
    }

    public static Locale[] getAvailableLocales() {
        return locResManager.getAvailableLocales();
    }

    public static String[] getISOCountries() {
        return locResManager.getISOCountries();
    }

    public static String[] getISOLanguages() {
        return locResManager.getISOLanguages();
    }

    static {
        defaultLoc = WONDERFUL_WORLD_OF_WONKA = new Locale("vl", "VL", "WONKA", 0);
        BELGIUM = new Locale("nl", "BE", "", 0);
        DUTCH = new Locale("nl", "", "", 0);
        CANADA = new Locale("en", "CA", "", 0);
        CHINA = new Locale("zh", "CN", "", 0);
        FRANCE = new Locale("fr", "FR", "", 0);
        GERMANY = new Locale("de", "DE", "", 0);
        ITALY = new Locale("it", "IT", "", 0);
        JAPAN = new Locale("ja", "JP", "", 0);
        KOREA = new Locale("ko", "KR", "", 0);
        PRC = new Locale("zh", "CN", "", 0);
        UK = new Locale("en", "GB", "", 0);
        US = new Locale("en", "US", "", 0);
        TAIWAN = new Locale("zh", "TW", "", 0);
        CANADA_FRENCH = new Locale("fr", "CA", "", 0);
        CHINESE = new Locale("zh", "", "", 0);
        ENGLISH = new Locale("en", "", "", 0);
        GERMAN = new Locale("de", "", "", 0);
        FRENCH = new Locale("fr", "", "", 0);
        ITALIAN = new Locale("it", "", "", 0);
        JAPANESE = new Locale("ja", "", "", 0);
        KOREAN = new Locale("ko", "", "", 0);
        SIMPLIFIED_CHINESE = new Locale("zh", "CN", "", 0);
        TRADITIONAL_CHINESE = new Locale("zh", "TW", "", 0);
    }
}

