/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    private static final long serialVersionUID = -8125100834729963327L;
    private static final int[] DAYS_IN_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] DAYS_IN_LEAPMONTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int AD = 1;
    public static final int BC = 0;
    private long gregorianCutover = -12219292800000L;

    public GregorianCalendar() {
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(TimeZone tz, Locale loc) {
        super(tz, loc);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(TimeZone tz) {
        super(tz, Locale.getDefault());
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(Locale loc) {
        super(TimeZone.getDefault(), loc);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int year, int month, int date) {
        this.set(year, month, date);
    }

    public GregorianCalendar(int year, int month, int date, int hour, int minute) {
        this.set(year, month, date, hour, minute);
    }

    public GregorianCalendar(int year, int month, int date, int hour, int minute, int second) {
        this.set(year, month, date, hour, minute, second);
    }

    public void add(int fld, int amount) throws IllegalArgumentException {
        if (fld == 16 || fld == 15) {
            throw new IllegalArgumentException();
        }
        int n = fld;
        this.fields[n] = this.fields[n] + amount;
        this.isTimeSet = false;
        this.complete();
    }

    public boolean after(Object cal) {
        if (!(cal instanceof GregorianCalendar)) {
            return false;
        }
        this.complete();
        return this.getTimeInMillis() > ((GregorianCalendar)cal).getTimeInMillis();
    }

    public boolean before(Object cal) {
        if (!(cal instanceof GregorianCalendar)) {
            return false;
        }
        this.complete();
        return this.getTimeInMillis() < ((GregorianCalendar)cal).getTimeInMillis();
    }

    protected void computeTime() {
        if (!this.isTimeSet) {
            if (!this.isSet[1]) {
                throw new IllegalArgumentException("no year set, please set the year if you like a time setting !");
            }
            int datecase = 1;
            if (!this.isSet[2] || !this.isSet[5]) {
                if (this.isSet[7] && this.isSet[2] && this.isSet[4]) {
                    datecase = 2;
                    if (this.fields[7] < 1 || this.fields[7] > 7 || this.fields[4] < 1 || this.fields[4] > 6) {
                        throw new IllegalArgumentException();
                    }
                } else if (this.isSet[7] && this.isSet[2] && this.isSet[8]) {
                    datecase = 3;
                } else if (this.isSet[6]) {
                    datecase = 4;
                } else if (this.isSet[7] && this.isSet[3]) {
                    datecase = 5;
                } else {
                    throw new IllegalArgumentException("please set enough values to determine a date !");
                }
            }
            if (!this.isSet[11]) {
                if (this.isSet[9] && this.isSet[10]) {
                    this.fields[11] = this.fields[9] * 12 + this.fields[10];
                } else {
                    throw new IllegalArgumentException("no time settings, sorry !");
                }
            }
            this.settime(this.getFirstDayOfWeek(), datecase);
            TimeZone tz = this.getTimeZone();
            if (this.fields[1] > 0) {
                int millis = this.fields[14] + 1000 * this.fields[13] + 60000 * this.fields[12] + 3600000 * this.fields[11];
                this.time -= (long)tz.getOffset(1, this.fields[1], this.fields[2], this.fields[5], this.fields[7], millis);
            } else {
                this.time -= (long)tz.getRawOffset();
            }
        }
        this.isTimeSet = true;
    }

    protected void computeFields() {
        if (!this.areFieldsSet) {
            int j;
            if (!this.isTimeSet) {
                throw new IllegalArgumentException();
            }
            TimeZone tz = this.getTimeZone();
            int rawOffset = tz.getRawOffset();
            this.setfields(rawOffset);
            int millis = this.fields[14] + 1000 * this.fields[13] + 60000 * this.fields[12] + 3600000 * this.fields[11];
            int dst = 0;
            if (this.fields[1] > 0) {
                dst = tz.getOffset(1, this.fields[1], this.fields[2], this.fields[5], this.fields[7], millis);
                this.setfields(dst);
                dst -= rawOffset;
                this.fields[0] = 1;
            } else {
                this.fields[0] = 0;
            }
            this.fields[10] = this.fields[11] % 12;
            this.fields[9] = this.fields[11] / 12;
            this.fields[8] = (this.fields[5] - 1) / 7 + 1;
            int fdow = this.getFirstDayOfWeek();
            int i = Math.abs((this.fields[7] - fdow) % 7);
            this.fields[4] = 1;
            for (j = this.fields[5]; j > i; j -= 7) {
                this.fields[4] = this.fields[4] + 1;
            }
            this.fields[3] = 1;
            for (j = this.fields[6]; j > i; j -= 7) {
                this.fields[3] = this.fields[3] + 1;
            }
            this.fields[15] = rawOffset;
            this.fields[16] = dst;
            for (j = 0; j < 17; ++j) {
                this.isSet[j] = true;
            }
            this.areFieldsSet = true;
        }
    }

    public boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year < 1582 || year % 100 != 0) {
            return true;
        }
        return year % 400 == 0;
    }

    public void roll(int fld, boolean up) {
        this.roll(fld, up ? 1 : -1);
    }

    public void roll(int fld, int amt) {
        switch (fld) {
            case 14: {
                int millis = this.get(fld);
                int value = millis + amt;
                amt = value / 1000;
                this.set(fld, value % 1000);
                if (amt == 0) break;
            }
            case 13: {
                int seconds = this.get(13);
                int value = seconds + amt;
                amt = value / 60;
                this.set(13, value % 60);
                if (amt == 0) break;
            }
            case 12: {
                int minutes = this.get(12);
                int value = minutes + amt;
                amt = value / 60;
                this.set(12, value % 60);
                if (amt == 0) break;
            }
            case 10: {
                int hours = this.get(10);
                int value = hours + amt;
                amt = value / 24;
                this.set(10, value % 24);
                if (amt == 0) break;
            }
            case 5: {
                int date = this.get(5);
                int value = date + amt;
                int month = this.get(2);
                int year = this.get(1);
                boolean leap = this.isLeapYear(year);
                if (value >= 0 && value <= (leap ? DAYS_IN_LEAPMONTH[month] : DAYS_IN_MONTH[month])) {
                    this.set(5, value);
                    break;
                }
                if (value >= 0) break;
                break;
            }
            case 2: {
                int month = this.get(2);
                int date = this.get(5);
                int value = month + amt;
                amt = value / 12;
                month = value % 12;
                if (date < DAYS_IN_MONTH[month]) {
                    this.set(5, DAYS_IN_MONTH[month]);
                }
                this.set(2, month);
                if (amt == 0) break;
            }
            case 1: {
                int year = this.get(fld);
                int newval = year + amt;
                if (this.isLeapYear(year) && this.get(2) == 1 && this.get(5) == 29 && !this.isLeapYear(newval)) {
                    this.set(5, 28);
                }
                this.set(fld, newval);
                break;
            }
            case 15: 
            case 16: {
                this.set(fld, this.get(fld) + amt);
                break;
            }
            case 0: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                System.out.println("\nGregorianCalendar: calling roll on field which is not yet implemented !!!\n");
            }
        }
    }

    public int getGreatestMinimum(int fld) {
        return -1;
    }

    public int getLeastMaximum(int fld) {
        return -1;
    }

    public int getMaximum(int fld) {
        return -1;
    }

    public int getMinimum(int fld) {
        return -1;
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    private native void setfields(int var1);

    private native void settime(int var1, int var2);
}

