/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    public static final Set EMPTY_SET = new FinalSet(new HashSet(0));
    public static final List EMPTY_LIST = new FinalList(new ArrayList(0));
    public static final Map EMPTY_MAP = new FinalMap(new HashMap(3));

    public static int binarySearch(List ls, Object e) {
        return Collections.binarySearch(ls, e, new StdComparator());
    }

    public static int binarySearch(List ls, Object e, Comparator comp) {
        int size = ls.size();
        for (int i = 0; i < size; ++i) {
            int cmp = comp.compare(e, ls.get(i));
            if (cmp == 0) {
                return i;
            }
            if (cmp >= 0) continue;
            size = i;
        }
        return -(size + 1);
    }

    public static void copy(List dest, List src) {
        if (dest.size() < src.size()) {
            throw new IndexOutOfBoundsException();
        }
        int size = src.size();
        for (int i = 0; i < size; ++i) {
            dest.set(i, src.get(i));
        }
    }

    public static Enumeration enumeration(Collection c) {
        return new Enum(c.iterator());
    }

    public static void fill(List ld, Object e) {
        int size = ld.size();
        for (int i = 0; i < size; ++i) {
            ld.set(i, e);
        }
    }

    public static Object max(Collection c) {
        return Collections.max(c, new StdComparator());
    }

    public static Object max(Collection c, Comparator comp) {
        Iterator it = c.iterator();
        Object max = it.next();
        while (it.hasNext()) {
            Object next = it.next();
            if (comp.compare(max, next) >= 0) continue;
            max = next;
        }
        return max;
    }

    public static Object min(Collection c) {
        return Collections.min(c, new StdComparator());
    }

    public static Object min(Collection c, Comparator comp) {
        Iterator it = c.iterator();
        Object min = it.next();
        while (it.hasNext()) {
            Object next = it.next();
            if (comp.compare(min, next) <= 0) continue;
            min = next;
        }
        return min;
    }

    public static List nCopies(int n, Object e) {
        if (n < 0) {
            throw new IllegalArgumentException("negative size specified: " + n);
        }
        ArrayList al = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            al.add(i, e);
        }
        return new FinalList(al);
    }

    public static void reverse(List ls) {
        int size = ls.size() - 1;
        for (int i = 0; i < size; ++i) {
            Object o = ls.set(i, ls.get(size));
            ls.set(size--, o);
        }
    }

    public static Comparator reverseOrder() {
        return new ReverseComparator();
    }

    public static void shuffle(List s) {
        Collections.shuffle(s, new Random());
    }

    public static void shuffle(List ls, Random r) {
        int size = ls.size();
        if (size > 1) {
            for (int i = 0; i < size; ++i) {
                int pos = r.nextInt(size);
                Object val = ls.set(i, ls.get(pos));
                ls.set(pos, val);
            }
        }
    }

    public static void sort(List list) {
        Collections.qSort(list, 0, list.size() - 1, new StdComparator());
    }

    public static void sort(List list, Comparator c) {
        Collections.qSort(list, 0, list.size() - 1, c);
    }

    private static void qSort(List ls, int l, int h, Comparator c) {
        if (h - l < 3) {
            Collections.fastSort(ls, l, h - l + 1, c);
        } else {
            int pivot = h;
            Collections.swap(ls, (l + h) / 2, h);
            Object pvt = ls.get(pivot);
            for (int i = l; i < pivot; ++i) {
                if (c.compare(pvt, ls.get(i)) >= 0) continue;
                if (i + 1 == pivot) {
                    Collections.swap(ls, i, pivot);
                    --pivot;
                    continue;
                }
                ls.set(pivot--, ls.get(i));
                Object o = ls.set(pivot, pvt);
                ls.set(i--, o);
            }
            Collections.qSort(ls, l, pivot - 1, c);
            Collections.qSort(ls, pivot + 1, h, c);
        }
    }

    private static void fastSort(List ls, int l, int s, Comparator c) {
        Object o;
        if (s >= 2 && c.compare(ls.get(l), ls.get(l + 1)) > 0) {
            o = ls.set(l + 1, ls.get(l));
            ls.set(l, o);
        }
        if (s >= 3 && c.compare(ls.get(l + 1), ls.get(l + 2)) > 0) {
            o = ls.set(l + 1, ls.get(l + 2));
            ls.set(l + 2, o);
            if (c.compare(ls.get(l), ls.get(l + 1)) > 0) {
                o = ls.set(l + 1, ls.get(l));
                ls.set(l, o);
            }
        }
    }

    private static void swap(List ls, int i, int j) {
        Object o = ls.set(i, ls.get(j));
        ls.set(j, o);
    }

    public static Set singleton(Object e) {
        HashSet hs = new HashSet(2);
        hs.add(e);
        return new FinalSet(hs);
    }

    public static List singletonList(Object e) {
        ArrayList hs = new ArrayList(2);
        hs.add(e);
        return new FinalList(hs);
    }

    public static Map singletonMap(Object k, Object v) {
        HashMap hs = new HashMap(3);
        hs.put(k, v);
        return new FinalMap(hs);
    }

    public static Collection synchronizedCollection(Collection c) {
        return new SyncedCollection(c);
    }

    public static List synchronizedList(List c) {
        return new SyncedList(c);
    }

    public static Map synchronizedMap(Map c) {
        return new SyncedMap(c);
    }

    public static Set synchronizedSet(Set c) {
        return new SyncedSet(c);
    }

    public static SortedMap synchronizedSortedMap(SortedMap c) {
        return new SyncedSortedMap(c);
    }

    public static SortedSet synchronizedSortedSet(SortedSet c) {
        return new SyncedSortedSet(c);
    }

    public static Collection unmodifiableCollection(Collection c) {
        return new FinalCollection(c);
    }

    public static List unmodifiableList(List c) {
        return new FinalList(c);
    }

    public static Map unmodifiableMap(Map c) {
        return new FinalMap(c);
    }

    public static Set unmodifiableSet(Set c) {
        return new FinalSet(c);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap c) {
        return new FinalSortedMap(c);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet c) {
        return new FinalSortedSet(c);
    }

    private static class SyncedSortedMap
    extends SyncedMap
    implements SortedMap {
        private SortedMap smap;

        public SyncedSortedMap(SortedMap m) {
            super(m);
            this.smap = m;
        }

        public synchronized Comparator comparator() {
            return this.smap.comparator();
        }

        public synchronized Object firstKey() {
            return this.smap.firstKey();
        }

        public synchronized Object lastKey() {
            return this.smap.lastKey();
        }

        public synchronized SortedMap headMap(Object toV) {
            return new SyncedSortedMap(this.smap.headMap(toV));
        }

        public synchronized SortedMap subMap(Object fromV, Object toV) {
            return new SyncedSortedMap(this.smap.subMap(fromV, toV));
        }

        public synchronized SortedMap tailMap(Object fromV) {
            return new SyncedSortedMap(this.smap.tailMap(fromV));
        }
    }

    private static class SyncedMap
    implements Map {
        protected Map back;

        public SyncedMap(Map c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.back = c;
        }

        public synchronized boolean equals(Object e) {
            return ((Object)this.back).equals(e);
        }

        public synchronized int hashCode() {
            return ((Object)this.back).hashCode();
        }

        public synchronized Object get(Object idx) {
            return this.back.get(idx);
        }

        public synchronized Object put(Object key, Object val) {
            return this.back.put(key, val);
        }

        public synchronized void putAll(Map e) {
            this.back.putAll(e);
        }

        public synchronized void clear() {
            this.back.clear();
        }

        public synchronized boolean containsKey(Object e) {
            return this.back.containsKey(e);
        }

        public synchronized boolean containsValue(Object e) {
            return this.back.containsValue(e);
        }

        public synchronized boolean isEmpty() {
            return this.back.isEmpty();
        }

        public synchronized Object remove(Object e) {
            return this.back.remove(e);
        }

        public synchronized int size() {
            return this.back.size();
        }

        public synchronized Set entrySet() {
            return new SyncedSet(this.back.entrySet());
        }

        public synchronized Set keySet() {
            return new SyncedSet(this.back.keySet());
        }

        public synchronized Collection values() {
            return new SyncedCollection(this.back.values());
        }
    }

    private static class SyncedSortedSet
    extends SyncedSet
    implements SortedSet {
        private SortedSet sset;

        public SyncedSortedSet(SortedSet s) {
            super(s);
            this.sset = s;
        }

        public synchronized Comparator comparator() {
            return this.sset.comparator();
        }

        public synchronized Object first() {
            return this.sset.first();
        }

        public synchronized Object last() {
            return this.sset.last();
        }

        public synchronized SortedSet headSet(Object toV) {
            return new SyncedSortedSet(this.sset.headSet(toV));
        }

        public synchronized SortedSet subSet(Object fromV, Object toV) {
            return new SyncedSortedSet(this.sset.subSet(fromV, toV));
        }

        public synchronized SortedSet tailSet(Object fromV) {
            return new SyncedSortedSet(this.sset.tailSet(fromV));
        }
    }

    private static class SyncedSet
    extends SyncedCollection
    implements Set {
        public SyncedSet(Set s) {
            super(s);
        }

        public synchronized boolean equals(Object e) {
            return ((Object)this.back).equals(e);
        }

        public synchronized int hashCode() {
            return ((Object)this.back).hashCode();
        }
    }

    private static class SyncedList
    extends SyncedCollection
    implements List {
        private List list;

        public SyncedList(List l) {
            super(l);
            this.list = l;
        }

        public synchronized List subList(int f, int t) {
            return new SyncedList(this.list.subList(f, t));
        }

        public synchronized void add(int p, Object t) {
            this.list.add(p, t);
        }

        public synchronized boolean addAll(int p, Collection t) {
            return this.list.addAll(p, t);
        }

        public synchronized ListIterator listIterator() {
            return this.list.listIterator();
        }

        public synchronized ListIterator listIterator(int p) {
            return this.list.listIterator(p);
        }

        public synchronized int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public synchronized int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public synchronized Object remove(int idx) {
            return this.list.remove(idx);
        }

        public synchronized Object get(int idx) {
            return this.list.get(idx);
        }

        public synchronized Object set(int idx, Object e) {
            return this.list.set(idx, e);
        }

        public synchronized boolean equals(Object e) {
            return ((Object)this.list).equals(e);
        }

        public synchronized int hashCode() {
            return ((Object)this.list).hashCode();
        }
    }

    private static class SyncedCollection
    implements Collection {
        protected Collection back;

        public SyncedCollection(Collection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.back = c;
        }

        public synchronized boolean add(Object e) {
            return this.back.add(e);
        }

        public synchronized boolean addAll(Collection e) {
            return this.back.addAll(e);
        }

        public synchronized void clear() {
            this.back.clear();
        }

        public synchronized boolean contains(Object e) {
            return this.back.contains(e);
        }

        public synchronized boolean containsAll(Collection e) {
            return this.back.containsAll(e);
        }

        public synchronized boolean isEmpty() {
            return this.back.isEmpty();
        }

        public synchronized Iterator iterator() {
            return this.back.iterator();
        }

        public synchronized boolean remove(Object e) {
            return this.back.remove(e);
        }

        public synchronized boolean removeAll(Collection c) {
            return this.back.removeAll(c);
        }

        public synchronized boolean retainAll(Collection c) {
            return this.back.retainAll(c);
        }

        public synchronized int size() {
            return this.back.size();
        }

        public synchronized Object[] toArray() {
            return this.back.toArray();
        }

        public synchronized Object[] toArray(Object[] a) {
            return this.back.toArray(a);
        }
    }

    private static class FinalSortedMap
    extends AbstractMap
    implements SortedMap {
        private SortedMap back;

        public FinalSortedMap(SortedMap bck) {
            if (bck == null) {
                throw new NullPointerException();
            }
            this.back = bck;
        }

        public int size() {
            return this.back.size();
        }

        public Set entrySet() {
            return new FinalSet(this.back.entrySet());
        }

        public Object firstKey() {
            return this.back.firstKey();
        }

        public Object lastKey() {
            return this.back.lastKey();
        }

        public SortedMap headMap(Object toV) {
            return new FinalSortedMap(this.back.headMap(toV));
        }

        public SortedMap subMap(Object fromV, Object toV) {
            return new FinalSortedMap(this.back.subMap(fromV, toV));
        }

        public SortedMap tailMap(Object fromV) {
            return new FinalSortedMap(this.back.tailMap(fromV));
        }

        public Comparator comparator() {
            return this.back.comparator();
        }
    }

    private static class FinalMap
    extends AbstractMap {
        private Map back;

        public FinalMap(Map bck) {
            if (bck == null) {
                throw new NullPointerException();
            }
            this.back = bck;
        }

        public int size() {
            return this.back.size();
        }

        public Set entrySet() {
            return new FinalSet(this.back.entrySet());
        }
    }

    private static class FinalSortedSet
    extends AbstractSet
    implements SortedSet {
        private SortedSet back;

        public FinalSortedSet(SortedSet bck) {
            if (bck == null) {
                throw new NullPointerException();
            }
            this.back = bck;
        }

        public int size() {
            return this.back.size();
        }

        public Iterator iterator() {
            return new UnmodIterator(this.back.iterator());
        }

        public Object first() {
            return this.back.first();
        }

        public Object last() {
            return this.back.last();
        }

        public SortedSet headSet(Object toV) {
            return new FinalSortedSet(this.back.headSet(toV));
        }

        public SortedSet subSet(Object fromV, Object toV) {
            return new FinalSortedSet(this.back.subSet(fromV, toV));
        }

        public SortedSet tailSet(Object fromV) {
            return new FinalSortedSet(this.back.tailSet(fromV));
        }

        public Comparator comparator() {
            return this.back.comparator();
        }
    }

    private static class FinalSet
    extends AbstractSet {
        private Set back;

        public FinalSet(Set bck) {
            if (bck == null) {
                throw new NullPointerException();
            }
            this.back = bck;
        }

        public int size() {
            return this.back.size();
        }

        public Iterator iterator() {
            return new UnmodIterator(this.back.iterator());
        }
    }

    private static class FinalList
    extends AbstractList {
        private List back;

        public FinalList(List bck) {
            if (bck == null) {
                throw new NullPointerException();
            }
            this.back = bck;
        }

        public int size() {
            return this.back.size();
        }

        public Object get(int idx) {
            return this.back.get(idx);
        }

        public Iterator iterator() {
            return new UnmodIterator(this.back.iterator());
        }
    }

    private static class FinalCollection
    extends AbstractCollection {
        private Collection back;

        public FinalCollection(Collection bck) {
            if (bck == null) {
                throw new NullPointerException();
            }
            this.back = bck;
        }

        public int size() {
            return this.back.size();
        }

        public Iterator iterator() {
            return new UnmodIterator(this.back.iterator());
        }
    }

    private static class UnmodIterator
    implements Iterator {
        private Iterator it;

        public UnmodIterator(Iterator i) {
            this.it = i;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return this.it.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class StdComparator
    implements Comparator {
        StdComparator() {
        }

        public int compare(Object one, Object two) {
            Comparable c1 = (Comparable)one;
            Comparable c2 = (Comparable)two;
            if (one != null) {
                return c1.compareTo(c2);
            }
            if (two != null) {
                return -c2.compareTo(c1);
            }
            return 0;
        }
    }

    static class ReverseComparator
    implements Comparator {
        ReverseComparator() {
        }

        public int compare(Object o1, Object o2) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            if (c2 != null) {
                return c2.compareTo(c1);
            }
            if (c1 != null) {
                return -c1.compareTo(c2);
            }
            return 0;
        }
    }

    private static class Enum
    implements Enumeration {
        private Iterator it;

        public Enum(Iterator i) {
            this.it = i;
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }
}

