/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class BitSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7997698588986878753L;
    private long[] bits;
    private transient int bitsInUse;

    private final int roundup(int n) {
        return (n + 63) / 64;
    }

    public String toString() {
        if (this.bitsInUse == 0) {
            return "{}";
        }
        long[] bits = this.bits;
        int length = bits.length;
        StringBuffer buf = new StringBuffer(3 * bits.length + 2);
        buf.append('{');
        int i = 0;
        while (i < length) {
            long l = bits[i];
            int j = 0;
            while (l != 0L) {
                if ((l & 1L) > 0L) {
                    buf.append(i * 64 + j);
                    buf.append(", ");
                }
                l >>>= 1;
                ++j;
            }
            ++i;
        }
        buf.setLength(buf.length() - 2);
        buf.append('}');
        return buf.toString();
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof BitSet)) {
            return false;
        }
        BitSet that = (BitSet)obj;
        int k = that.bits.length;
        int l = this.bits.length;
        if (k > l) {
            int i = 0;
            while (i < l) {
                if (this.bits[i] != that.bits[i]) {
                    return false;
                }
                ++i;
            }
            int j = l;
            while (j < k) {
                if (that.bits[j] != 0L) {
                    return false;
                }
                ++j;
            }
        } else {
            int i = 0;
            while (i < k) {
                if (this.bits[i] != that.bits[i]) {
                    return false;
                }
                ++i;
            }
            int j = k;
            while (j < l) {
                if (this.bits[j] != 0L) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    public synchronized int hashCode() {
        long h = 1234L;
        int i = this.bits.length - 1;
        while (i >= 0) {
            h ^= this.bits[i] * (long)(i + 1);
            --i;
        }
        return (int)(h >> 32 ^ h);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Object clone() {
        try {
            void cne;
            BitSet clone = (BitSet)super.clone();
            clone.bits = (long[])this.bits.clone();
            return cne;
        }
        catch (CloneNotSupportedException cne) {
            return null;
        }
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.bitsInUse < bitIndex) {
            return false;
        }
        boolean bl = false;
        if ((this.bits[bitIndex / 64] >> bitIndex % 64 & 1L) > 0L) {
            bl = true;
        }
        return bl;
    }

    private final void grow() {
        if (this.bitsInUse > this.bits.length * 64) {
            long[] nbits = new long[this.roundup(this.bitsInUse)];
            System.arraycopy(this.bits, 0, nbits, 0, this.bits.length);
            this.bits = nbits;
        }
    }

    public synchronized void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bitIndex >= this.bitsInUse) {
            this.bitsInUse = bitIndex + 1;
            this.grow();
        }
        int i = bitIndex / 64;
        this.bits[i] = this.bits[i] | 1L << bitIndex % 64;
    }

    public synchronized void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.bitsInUse > bitIndex) {
            int i = bitIndex / 64;
            this.bits[i] = this.bits[i] & (1L << bitIndex % 64 ^ (long)-1);
        }
        this.checkBitsInUse();
    }

    public void and(BitSet bitset) {
        int k = bitset.bits.length;
        long[] bits = this.bits;
        int l = bits.length;
        if (k < l) {
            int j = k;
            while (j < l) {
                bits[j] = 0L;
                ++j;
            }
            l = k;
        }
        long[] others = bitset.bits;
        int i = 0;
        while (i < l) {
            bits[i] = bits[i] & others[i];
            ++i;
        }
        this.checkBitsInUse();
    }

    public void or(BitSet bitset) {
        int k = bitset.bits.length;
        long[] bits = this.bits;
        int l = bits.length;
        if (k < l) {
            l = k;
        }
        long[] others = bitset.bits;
        int i = 0;
        while (i < l) {
            bits[i] = bits[i] | others[i];
            ++i;
        }
        this.checkBitsInUse();
    }

    public synchronized void xor(BitSet bitset) {
        int k = bitset.bits.length;
        long[] bits = this.bits;
        int l = bits.length;
        if (k < l) {
            l = k;
        }
        long[] others = bitset.bits;
        int i = 0;
        while (i < l) {
            bits[i] = bits[i] ^ others[i];
            ++i;
        }
        this.checkBitsInUse();
    }

    public int size() {
        return this.bits.length * 64;
    }

    public int length() {
        return this.bitsInUse;
    }

    public void andNot(BitSet bs) {
        long[] others = bs.bits;
        int k = others.length;
        long[] bits = this.bits;
        int l = bits.length;
        if (k < l) {
            l = k;
        }
        int i = 0;
        while (i < l) {
            bits[i] = bits[i] & (others[i] ^ (long)-1);
            ++i;
        }
        this.checkBitsInUse();
    }

    private final void checkBitsInUse() {
        long[] bits = this.bits;
        int l = bits.length - 1;
        if (l >= 0) {
            while (bits[l] == 0L) {
                if (--l >= 0) continue;
                this.bitsInUse = 0;
                return;
            }
            long value = bits[l] >>> 1;
            int i = 1;
            while (value != 0L) {
                value >>>= 1;
                ++i;
            }
            this.bitsInUse = l * 64 + i;
        }
    }

    private final void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.checkBitsInUse();
    }

    public BitSet() {
        this.bits = new long[1];
    }

    public BitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException();
        }
        this.bits = new long[this.roundup(nbits)];
    }
}

