/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;

public final class StringCharacterIterator
implements CharacterIterator {
    private int beginIndex;
    private int current;
    private int endIndex;
    private String source;

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public final char current() {
        if (this.current >= this.endIndex) {
            return (char)-1;
        }
        return this.source.charAt(this.current);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof StringCharacterIterator)) {
            return false;
        }
        StringCharacterIterator sci = (StringCharacterIterator)o;
        boolean bl = false;
        if (this.beginIndex == sci.beginIndex && this.endIndex == sci.endIndex && this.current == sci.current && this.source.equals(sci.source)) {
            bl = true;
        }
        return bl;
    }

    public final char first() {
        if (this.endIndex == this.beginIndex) {
            return (char)-1;
        }
        this.current = this.beginIndex;
        return this.source.charAt(this.current);
    }

    public final int getBeginIndex() {
        return this.beginIndex;
    }

    public final int getEndIndex() {
        return this.endIndex;
    }

    public final int getIndex() {
        return this.current;
    }

    public final int hashCode() {
        return this.endIndex ^ this.beginIndex ^ this.current ^ this.source.hashCode();
    }

    public final char last() {
        if (this.endIndex == this.beginIndex) {
            return (char)-1;
        }
        this.current = this.endIndex - 1;
        return this.source.charAt(this.current);
    }

    public final char next() {
        if (this.current >= this.endIndex - 1) {
            this.current = this.endIndex;
            return (char)-1;
        }
        return this.source.charAt(++this.current);
    }

    public final char previous() {
        if (this.current <= this.beginIndex) {
            return (char)-1;
        }
        return this.source.charAt(--this.current);
    }

    public final char setIndex(int idx) {
        if (idx < this.beginIndex || idx > this.endIndex) {
            throw new IllegalArgumentException();
        }
        this.current = idx;
        if (this.current == this.endIndex) {
            return (char)-1;
        }
        return this.source.charAt(this.current);
    }

    public final void setText(String txt) {
        this.endIndex = txt.length();
        this.beginIndex = 0;
        this.current = 0;
        this.source = txt;
    }

    public StringCharacterIterator(String text) {
        this.source = text;
        this.endIndex = text.length();
    }

    public StringCharacterIterator(String text, int index) {
        this.endIndex = text.length();
        if (index < 0 || index > this.endIndex) {
            throw new IllegalArgumentException();
        }
        this.source = text;
        this.current = index;
    }

    public StringCharacterIterator(String text, int begin, int end, int index) {
        if (begin < 0 || index < begin || index > end || begin > end || end > text.length()) {
            throw new IllegalArgumentException();
        }
        this.source = text;
        this.current = index;
        this.beginIndex = begin;
        this.endIndex = end;
    }
}

