/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class SimpleDateFormat
extends DateFormat {
    static final FieldPosition TRASHPOSITION = new FieldPosition(0);
    private static final long serialVersionUID = 4774881970558875024L;
    private static final DateFormatSymbols DEFAULTSYMBOLS = new DateFormatSymbols();
    private static final String PATTERNCHARS = "GyMdkHmsSEDFwWahKz";
    private static final int[] FIELDMAP = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10};
    private Date defaultCenturyStart = new Date();
    private DateFormatSymbols formatData;
    private String pattern;
    private int serialVersionOnStream = 1;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.serialVersionOnStream = 1;
            this.defaultCenturyStart = new Date();
        }
    }

    public SimpleDateFormat() {
        this("dd.MM.yy  hh:mm:ss", new DateFormatSymbols());
    }

    public SimpleDateFormat(String pattern) {
        this(pattern, new DateFormatSymbols());
    }

    public SimpleDateFormat(String pattern, Locale loc) {
        this(pattern, new DateFormatSymbols(loc));
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols dfs) {
        if (pattern == null || dfs == null) {
            throw new NullPointerException();
        }
        this.calendar = Calendar.getInstance();
        this.numberFormat = NumberFormat.getInstance();
        this.formatData = dfs;
        this.pattern = pattern;
    }

    public void applyLocalizedPattern(String pattern) {
        String local = this.formatData.getLocalPatternChars();
        this.pattern = this.toPattern(pattern, local, PATTERNCHARS);
    }

    public void applyPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
    }

    public Object clone() {
        SimpleDateFormat sdf = (SimpleDateFormat)super.clone();
        sdf.formatData = (DateFormatSymbols)this.formatData.clone();
        sdf.defaultCenturyStart = (Date)this.defaultCenturyStart.clone();
        return sdf;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleDateFormat)) {
            return false;
        }
        SimpleDateFormat sdf = (SimpleDateFormat)o;
        return this.pattern.equals(sdf.pattern);
    }

    public StringBuffer format(Date date, StringBuffer dest, FieldPosition pos) {
        this.calendar.setTime(date);
        int size = this.pattern.length();
        boolean formatting = true;
        for (int i = 0; i < size; ++i) {
            int field;
            char ch = this.pattern.charAt(i);
            if (ch == '\'') {
                if (++i < size && this.pattern.charAt(i) == ch) {
                    dest.append(ch);
                    continue;
                }
                --i;
                formatting = !formatting;
                continue;
            }
            if (formatting && (field = PATTERNCHARS.indexOf(ch)) != -1) {
                i = this.writeField(ch, i, field, dest, pos);
                continue;
            }
            dest.append(ch);
        }
        return dest;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return this.formatData;
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public int hashCode() {
        return this.pattern.hashCode() ^ 0xAAAAAAAA;
    }

    public Date parse(String str, ParsePosition pos) {
        TimeZone current = this.calendar.getTimeZone();
        int size = this.pattern.length();
        boolean formatting = true;
        int p = pos.getIndex();
        boolean checkDST = false;
        int i = 0;
        while (i < size) {
            int field;
            char ch = this.pattern.charAt(i);
            if (ch == '\'') {
                if (++i < size && this.pattern.charAt(i) == ch) {
                    if (str.charAt(p) != ch) {
                        pos.setIndex(p);
                        pos.setErrorIndex(p);
                        return null;
                    }
                } else {
                    --i;
                    formatting = !formatting;
                    --p;
                }
            } else if (formatting && (field = PATTERNCHARS.indexOf(ch)) != -1) {
                pos.setIndex(p);
                if (field == 17) {
                    int nr = 1;
                    ++i;
                    while (i < size && this.pattern.charAt(i) == ch) {
                        ++nr;
                        ++i;
                    }
                    --i;
                    int res = this.formatData.parseTimeZoneString(this.calendar, nr > 3, str, pos);
                    if (res == -1) {
                        return null;
                    }
                    checkDST = res == 1;
                } else {
                    if ((i = this.readField(ch, i, field, str, pos)) == -1) {
                        return null;
                    }
                    p = pos.getIndex() - 1;
                }
            } else if (str.charAt(p) != ch) {
                pos.setIndex(p);
                pos.setErrorIndex(p);
                return null;
            }
            ++i;
            ++p;
        }
        pos.setIndex(p);
        Date time = this.calendar.getTime();
        if (checkDST && this.calendar.getTimeZone().inDaylightTime(time)) {
            time.setTime(time.getTime() + (long)((SimpleTimeZone)this.calendar.getTimeZone()).getDSTSavings());
        }
        this.calendar.setTimeZone(current);
        return time;
    }

    public void setDateFormatSymbols(DateFormatSymbols dfs) {
        this.formatData = dfs;
    }

    public void set2DigitYearStart(Date date) {
        if (date == null) {
            throw new NullPointerException();
        }
        this.defaultCenturyStart = date;
    }

    public String toLocalizedPattern() {
        return this.toPattern(this.pattern, PATTERNCHARS, this.formatData.getLocalPatternChars());
    }

    public String toPattern() {
        return this.pattern;
    }

    private String toPattern(String pattern, String from, String to) {
        int size = pattern.length();
        char[] chars = new char[size];
        pattern.getChars(0, size, chars, 0);
        for (int i = 0; i < size; ++i) {
            char ch = chars[i];
            if (ch == '\'') {
                int q = pattern.indexOf(ch, i + 1);
                if (i + 1 == q) {
                    ++i;
                    continue;
                }
                while (q != -1 && ++q < size && ch == pattern.charAt(q)) {
                    q = pattern.indexOf(ch, q + 1);
                }
                i = q == -1 ? size : q - 1;
                continue;
            }
            int p = from.indexOf(ch);
            if (p == -1) continue;
            chars[i] = to.charAt(p);
        }
        return new String(chars, 0, size);
    }

    private int readField(char ch, int idx, int field, String dest, ParsePosition pos) {
        int i;
        int nr = 1;
        int pattern_length = this.pattern.length();
        for (i = idx + 1; i < pattern_length && this.pattern.charAt(i) == ch; ++i) {
            ++nr;
        }
        idx = i - 1;
        switch (ch) {
            case 'M': {
                if (nr < 3) {
                    this.numberFormat.minimumIntegerDigits = nr;
                    this.numberFormat.maximumIntegerDigits = 2;
                    Number num1 = this.numberFormat.parse(dest, pos);
                    if (num1 != null) {
                        this.calendar.set(2, num1.intValue() - 1);
                        break;
                    }
                    return -1;
                }
                String[] ms1 = nr == 3 ? this.formatData.getShortMonths() : this.formatData.getMonths();
                return this.arrayLookup(ms1, dest, pos, field, idx, true);
            }
            case 'y': {
                this.numberFormat.minimumIntegerDigits = nr;
                this.numberFormat.maximumIntegerDigits = nr == 2 ? 2 : (nr > 4 ? nr : 4);
                Number num2 = this.numberFormat.parse(dest, pos);
                if (num2 != null) {
                    int year = num2.intValue();
                    if (nr < 3) {
                        GregorianCalendar gc = new GregorianCalendar(0, 0, 0);
                        gc.setTime(this.defaultCenturyStart);
                        int cent = gc.get(1);
                        year += cent - cent % 100;
                    }
                    this.calendar.set(1, year);
                    break;
                }
                return -1;
            }
            case 'H': 
            case 'K': 
            case 'W': 
            case 'd': 
            case 'm': 
            case 's': 
            case 'w': {
                this.numberFormat.minimumIntegerDigits = nr;
                this.numberFormat.maximumIntegerDigits = nr > 2 ? nr : 2;
                Number num3 = this.numberFormat.parse(dest, pos);
                if (num3 != null) {
                    this.calendar.set(FIELDMAP[field], num3.intValue());
                    break;
                }
                return -1;
            }
            case 'D': {
                this.numberFormat.minimumIntegerDigits = nr;
                this.numberFormat.maximumIntegerDigits = nr > 3 ? nr : 3;
                Number num4 = this.numberFormat.parse(dest, pos);
                if (num4 != null) {
                    this.calendar.set(FIELDMAP[field], num4.intValue());
                    break;
                }
                return -1;
            }
            case 'S': {
                this.numberFormat.minimumIntegerDigits = 3;
                this.numberFormat.maximumIntegerDigits = 3;
                Number num5 = this.numberFormat.parse(dest, pos);
                if (num5 != null) {
                    this.calendar.set(FIELDMAP[field], num5.intValue());
                    break;
                }
                return -1;
            }
            case 'F': {
                this.numberFormat.minimumIntegerDigits = nr;
                this.numberFormat.maximumIntegerDigits = nr;
                Number num6 = this.numberFormat.parse(dest, pos);
                if (num6 != null) {
                    this.calendar.set(FIELDMAP[field], num6.intValue());
                    break;
                }
                return -1;
            }
            case 'a': {
                return this.arrayLookup(this.formatData.getAmPmStrings(), dest, pos, field, idx, true);
            }
            case 'E': {
                int res;
                if (nr > 3 && (res = this.arrayLookup(this.formatData.getWeekdays(), dest, pos, field, idx, false)) != -1) {
                    return res;
                }
                return this.arrayLookup(this.formatData.getShortWeekdays(), dest, pos, field, idx, true);
            }
            case 'h': {
                this.numberFormat.minimumIntegerDigits = nr;
                this.numberFormat.maximumIntegerDigits = nr > 2 ? nr : 2;
                Number num7 = this.numberFormat.parse(dest, pos);
                if (num7 != null) {
                    this.calendar.set(FIELDMAP[field], num7.intValue() % 12);
                    break;
                }
                return -1;
            }
            case 'k': {
                Number num8 = this.numberFormat.parse(dest, pos);
                if (num8 != null) {
                    this.calendar.set(FIELDMAP[field], num8.intValue() % 24);
                    break;
                }
                return -1;
            }
            case 'G': {
                return this.arrayLookup(this.formatData.getEras(), dest, pos, field, idx, true);
            }
            default: {
                return -1;
            }
        }
        return idx;
    }

    private int arrayLookup(String[] strings, String source, ParsePosition pos, int field, int idx, boolean set) {
        int start = pos.getIndex();
        for (int i = 0; i < strings.length; ++i) {
            int len = strings[i].length();
            if (len <= 0 || !source.regionMatches(start, strings[i], 0, len)) continue;
            this.calendar.set(FIELDMAP[field], i);
            pos.setIndex(start + len);
            return idx;
        }
        if (set) {
            pos.setErrorIndex(start);
        }
        return -1;
    }

    private int writeField(char ch, int idx, int field, StringBuffer dest, FieldPosition pos) {
        int i;
        int nr = 1;
        int start = dest.length();
        int pattern_length = this.pattern.length();
        for (i = idx + 1; i < pattern_length && this.pattern.charAt(i) == ch; ++i) {
            ++nr;
        }
        idx = i - 1;
        switch (ch) {
            case 'M': {
                int m = this.calendar.get(2);
                if (nr < 3) {
                    this.numberFormat.setMinimumIntegerDigits(nr);
                    this.numberFormat.format(m + 1, dest, TRASHPOSITION);
                    break;
                }
                String[] ms = nr == 3 ? this.formatData.getShortMonths() : this.formatData.getMonths();
                dest.append(ms[m]);
                break;
            }
            case 'y': {
                this.numberFormat.setMinimumIntegerDigits(nr);
                this.numberFormat.format(this.calendar.get(1), dest, TRASHPOSITION);
                if (nr >= 4) break;
                dest.delete(start, dest.length() - 2);
                break;
            }
            case 'H': 
            case 'K': 
            case 'W': 
            case 'd': 
            case 'm': 
            case 's': 
            case 'w': {
                this.numberFormat.setMinimumIntegerDigits(2 < nr ? 2 : nr);
                this.numberFormat.format(this.calendar.get(FIELDMAP[field]), dest, TRASHPOSITION);
                break;
            }
            case 'D': {
                this.numberFormat.setMinimumIntegerDigits(3 < nr ? 3 : nr);
                this.numberFormat.format(this.calendar.get(FIELDMAP[field]), dest, TRASHPOSITION);
                break;
            }
            case 'F': {
                this.numberFormat.setMinimumIntegerDigits(1);
                this.numberFormat.format(this.calendar.get(FIELDMAP[field]), dest, TRASHPOSITION);
                break;
            }
            case 'a': {
                dest.append(this.formatData.getAmPmStrings()[this.calendar.get(9)]);
                break;
            }
            case 'E': {
                String[] ms = nr <= 3 ? this.formatData.getShortWeekdays() : this.formatData.getWeekdays();
                dest.append(ms[this.calendar.get(7)]);
                break;
            }
            case 'z': {
                dest.append(this.formatData.getTimeZoneString(this.calendar, nr > 3));
                break;
            }
            case 'S': {
                this.numberFormat.setMinimumIntegerDigits(3);
                this.numberFormat.format(this.calendar.get(14), dest, TRASHPOSITION);
                break;
            }
            case 'h': {
                this.numberFormat.setMinimumIntegerDigits(nr);
                int h = this.calendar.get(FIELDMAP[field]);
                this.numberFormat.format(h == 0 ? 12 : h, dest, TRASHPOSITION);
                break;
            }
            case 'k': {
                this.numberFormat.setMinimumIntegerDigits(nr);
                int k = this.calendar.get(FIELDMAP[field]);
                this.numberFormat.format(k == 0 ? 24 : k, dest, TRASHPOSITION);
                break;
            }
            case 'G': {
                dest.append(this.formatData.getEras()[this.calendar.get(0)]);
            }
        }
        if (field == pos.getField()) {
            pos.setBeginIndex(start);
            pos.setEndIndex(dest.length());
        }
        return idx;
    }
}

