/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DateFormat
extends Format {
    private static final long serialVersionUID = 7218322306649953788L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;
    public static final int AM_PM_FIELD = 14;
    public static final int DATE_FIELD = 3;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int ERA_FIELD = 0;
    public static final int HOUR0_FIELD = 16;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int MILLISECOND_FIELD = 8;
    public static final int MINUTE_FIELD = 6;
    public static final int MONTH_FIELD = 2;
    public static final int SECOND_FIELD = 7;
    public static final int TIMEZONE_FIELD = 17;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int YEAR_FIELD = 1;
    private static final String[] DATESTYLES = new String[]{"EEEE, MMMM d, yyyy G", "MMMM d, yyyy", "d-MMM-yy", "M/d/yy"};
    private static final String[] TIMESTYLES = new String[]{"K:mm:ss 'o''clock' a z", "K:mm:ss a z", "K:mm:ss a", "K:mm a"};
    protected Calendar calendar;
    protected NumberFormat numberFormat;

    public static Locale[] getAvailableLocales() {
        return new Locale[0];
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.getDateInstance(2, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int style) {
        return DateFormat.getDateInstance(style, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int style, Locale loc) {
        return new SimpleDateFormat(DATESTYLES[style], loc);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int date, int time) {
        return DateFormat.getDateTimeInstance(date, time, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int date, int time, Locale loc) {
        String pattern = DATESTYLES[date] + ' ' + TIMESTYLES[time];
        return new SimpleDateFormat(pattern, loc);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance() {
        return DateFormat.getTimeInstance(2, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int style) {
        return DateFormat.getTimeInstance(style, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int style, Locale loc) {
        return new SimpleDateFormat(TIMESTYLES[style], loc);
    }

    protected DateFormat() {
    }

    public Object clone() {
        DateFormat df = (DateFormat)super.clone();
        df.calendar = (Calendar)this.calendar.clone();
        df.numberFormat = (NumberFormat)this.numberFormat.clone();
        return df;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateFormat)) {
            return false;
        }
        DateFormat df = (DateFormat)o;
        return this.calendar.equals(df.calendar) && this.numberFormat.equals(df.numberFormat);
    }

    public final StringBuffer format(Object o, StringBuffer buffer, FieldPosition pos) {
        Date date = o instanceof Number ? new Date(((Number)o).longValue()) : (Date)o;
        return this.format(date, buffer, pos);
    }

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    public final String format(Date date) {
        return this.format(date, new StringBuffer(64), new FieldPosition(0)).toString();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public int hashCode() {
        return this.calendar.hashCode() ^ this.numberFormat.hashCode();
    }

    public boolean isLenient() {
        return this.calendar.isLenient();
    }

    public Date parse(String date) throws ParseException {
        ParsePosition pp = new ParsePosition(0);
        Date d = this.parse(date, pp);
        if (d == null) {
            throw new ParseException("parsing failed!", pp.getErrorIndex());
        }
        return d;
    }

    public abstract Date parse(String var1, ParsePosition var2);

    public Object parseObject(String date, ParsePosition pp) {
        return this.parse(date, pp);
    }

    public void setCalendar(Calendar cal) {
        this.calendar = cal;
    }

    public void setLenient(boolean lenient) {
        this.calendar.setLenient(lenient);
    }

    public void setNumberFormat(NumberFormat nf) {
        this.numberFormat = nf;
    }

    public void setTimeZone(TimeZone tz) {
        this.calendar.setTimeZone(tz);
    }
}

