/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.StringTokenizer;

public class ChoiceFormat
extends NumberFormat {
    private static final long serialVersionUID = 1795184449645032964L;
    private String[] choiceFormats;
    private double[] choiceLimits;

    public static final double nextDouble(double d) {
        return ChoiceFormat.nextDouble(d, true);
    }

    public static double nextDouble(double d, boolean next) {
        if (!Double.isNaN(d)) {
            if (Double.isInfinite(d)) {
                if (d > 0.0 && !next) {
                    return Double.MAX_VALUE;
                }
                if (d < 0.0 && next) {
                    return -1.7976931348623157E308;
                }
                return d;
            }
            if (d == 0.0) {
                return next ? Double.MIN_VALUE : -4.9E-324;
            }
            if (!next && d <= -1.7976931348623157E308) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.longBitsToDouble(Double.doubleToLongBits(d) + (long)(next ? 1 : -1));
        }
        return Double.NaN;
    }

    public static final double previousDouble(double d) {
        return ChoiceFormat.nextDouble(d, false);
    }

    private final void checkLimits(double[] limits) {
        double prev = limits[0];
        int i = 1;
        while (i < limits.length) {
            double next = limits[i];
            if (next < prev) {
                throw new IllegalArgumentException();
            }
            prev = next;
            ++i;
        }
    }

    private final double parseDouble(String value) {
        value = value.trim();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            if (value.equals("-\u221e")) {
                return Double.NEGATIVE_INFINITY;
            }
            if (value.equals("\u221e")) {
                return Double.POSITIVE_INFINITY;
            }
            throw new IllegalArgumentException("bad double value encountered");
        }
    }

    public void applyPattern(String pattern) {
        StringTokenizer st = new StringTokenizer(pattern, "|");
        int len = st.countTokens();
        if (len == 0) {
            throw new IllegalArgumentException("pattern contains no choices");
        }
        String[] formats = new String[len];
        double[] limits = new double[len];
        int i = 0;
        while (i < len) {
            double d;
            String token = st.nextToken();
            int idx = token.indexOf(60);
            if (idx == -1) {
                idx = token.indexOf(35);
                if (idx == -1 && (idx = token.indexOf(8804)) == -1) {
                    throw new IllegalArgumentException("bad pattern applied");
                }
                limits[i] = d = this.parseDouble(token.substring(0, idx));
            } else {
                limits[i] = d = ChoiceFormat.nextDouble(this.parseDouble(token.substring(0, idx)));
            }
            formats[i] = token.substring(idx + 1);
            ++i;
        }
        this.checkLimits(limits);
        this.choiceFormats = formats;
        this.choiceLimits = limits;
    }

    public Object clone() {
        ChoiceFormat cf = (ChoiceFormat)super.clone();
        cf.choiceLimits = (double[])this.choiceLimits.clone();
        cf.choiceFormats = (String[])this.choiceFormats.clone();
        return cf;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChoiceFormat)) {
            return false;
        }
        ChoiceFormat cf = (ChoiceFormat)o;
        boolean bl = false;
        if (Arrays.equals(this.choiceFormats, cf.choiceFormats) && Arrays.equals(this.choiceLimits, cf.choiceLimits)) {
            bl = true;
        }
        return bl;
    }

    public StringBuffer format(long num, StringBuffer app, FieldPosition pos) {
        return this.format((double)num, app, pos);
    }

    public StringBuffer format(double num, StringBuffer app, FieldPosition pos) {
        if (Double.isNaN(num)) {
            app.append(this.choiceFormats[0]);
        } else {
            int i = 0;
            while (i < this.choiceLimits.length) {
                double limit = this.choiceLimits[i];
                if (num < limit) {
                    int n = 0;
                    if (i > 0) {
                        n = i - 1;
                    }
                    app.append(this.choiceFormats[n]);
                    return app;
                }
                ++i;
            }
            int l = this.choiceFormats.length;
            if (l > 0) {
                app.append(this.choiceFormats[l - 1]);
            }
        }
        return app;
    }

    public Object[] getFormats() {
        return this.choiceFormats;
    }

    public double[] getLimits() {
        return this.choiceLimits;
    }

    public int hashCode() {
        int hash = 1;
        if (this.choiceLimits != null) {
            int i = 0;
            while (i < this.choiceLimits.length) {
                hash = (int)((long)hash + (Double.doubleToLongBits(this.choiceLimits[i]) ^ (long)this.choiceFormats[i].hashCode()));
                ++i;
            }
        }
        return hash;
    }

    public Number parse(String srcStr, ParsePosition pos) {
        int start = pos.getIndex();
        int i = 0;
        while (i < this.choiceFormats.length) {
            if (srcStr.regionMatches(start, this.choiceFormats[i], 0, this.choiceFormats[i].length())) {
                pos.setIndex(start + this.choiceFormats[i].length());
                return new Double(this.choiceLimits[i]);
            }
            ++i;
        }
        return new Double(Double.NaN);
    }

    public void setChoices(double[] limits, String[] formats) {
        if (limits.length != formats.length || limits.length == 0) {
            throw new IllegalArgumentException();
        }
        this.checkLimits(limits);
        this.choiceFormats = formats;
        this.choiceLimits = limits;
    }

    public String toPattern() {
        StringBuffer pattern = new StringBuffer(128);
        int i = 0;
        while (i < this.choiceLimits.length) {
            pattern.append(this.choiceLimits[i]);
            pattern.append('#');
            pattern.append(this.choiceFormats[i]);
            pattern.append('|');
            ++i;
        }
        pattern.setLength(pattern.length() - 1);
        return pattern.toString();
    }

    public ChoiceFormat(String newPattern) {
        this.applyPattern(newPattern);
    }

    public ChoiceFormat(double[] limits, String[] formats) {
        this.setChoices(limits, formats);
    }
}

