/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;

public class CertificateFactory {
    private CertificateFactorySpi certFacSpi;
    private Provider provider;
    private String type;

    public static CertificateFactory getInstance(String type) throws NoSuchAlgorithmException {
        CertAction action = new CertAction(type, "CertificateFactory.");
        return new CertificateFactory((CertificateFactorySpi)action.spi, action.provider, type);
    }

    public static CertificateFactory getInstance(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        CertAction action = new CertAction(type, provider, "CertificateFactory.");
        return new CertificateFactory((CertificateFactorySpi)action.spi, action.provider, type);
    }

    protected CertificateFactory(CertificateFactorySpi certFacSpi, Provider provider, String type) {
        this.type = type;
        this.provider = provider;
        this.certFacSpi = certFacSpi;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Certificate generateCertificate(InputStream in) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificate(in);
    }

    public final Collection generateCertificates(InputStream in) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificates(in);
    }

    public final CRL generateCRL(InputStream in) throws CRLException {
        return this.certFacSpi.engineGenerateCRL(in);
    }

    public final Collection generateCRLs(InputStream in) throws CRLException {
        return this.certFacSpi.engineGenerateCRLs(in);
    }
}

