/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.security.SecurityAction;
import java.util.Enumeration;
import java.util.Random;

public class SecureRandom
extends Random {
    private static final long serialVersionUID = 4940670005562187L;
    private long counter;
    private MessageDigest digest;
    private Provider provider;
    private byte[] randomBytes;
    private int randomBytesUsed;
    private SecureRandomSpi secureRandomSpi;
    private byte[] state;

    public static SecureRandom getInstance(String algorithm) throws NoSuchAlgorithmException {
        SecurityAction action = new SecurityAction(algorithm, "SecureRandom.");
        return new SecureRandom((SecureRandomSpi)action.spi, action.provider);
    }

    public static SecureRandom getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityAction action = new SecurityAction(algorithm, provider, "SecureRandom.");
        return new SecureRandom((SecureRandomSpi)action.spi, action.provider);
    }

    public static byte[] getSeed(int numBytes) {
        return new SecureRandom().generateSeed(numBytes);
    }

    public SecureRandom() {
        Provider[] p = Security.getProviders();
        block2: for (int i = 0; i < p.length; ++i) {
            Provider prov = p[i];
            Enumeration e = prov.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("SecureRandom.")) continue;
                String classname = prov.getProperty(key);
                try {
                    this.secureRandomSpi = (SecureRandomSpi)Class.forName(classname, true, SecurityAction.getClassLoader(prov)).newInstance();
                    this.provider = prov;
                    i = p.length;
                    continue block2;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (this.secureRandomSpi == null) {
            throw new RuntimeException("couldn't find a SecureRandom");
        }
    }

    public SecureRandom(byte[] seed) {
        this();
        this.setSeed(seed);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
    }

    public byte[] generateSeed(int numBytes) {
        return this.secureRandomSpi.engineGenerateSeed(numBytes);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    protected final int next(int numBits) {
        if (numBits <= 0 || numBits > 32) {
            throw new IllegalArgumentException();
        }
        int bts = (numBits - 1) / 8 + 1;
        byte[] bytes = new byte[bts];
        this.nextBytes(bytes);
        if (bts > 0) {
            int mod = 255 >> 8 - numBits % 8;
            bytes[bts - 1] = (byte)(0xFF & (char)bytes[bts - 1] & mod);
        }
        int next = 0;
        for (int i = 0; i < bts; ++i) {
            next = (next << 8) + (0xFF & (char)bytes[i]);
        }
        return next;
    }

    public void nextBytes(byte[] bytes) {
        this.secureRandomSpi.engineNextBytes(bytes);
    }

    public void setSeed(byte[] seed) {
        this.secureRandomSpi.engineSetSeed(seed);
    }

    public void setSeed(long seed) {
        if (this.secureRandomSpi != null) {
            byte[] bytes = new byte[8];
            for (int i = 0; i < 8; ++i) {
                bytes[i] = (byte)seed;
                seed >>= 8;
            }
            this.setSeed(bytes);
        }
    }
}

