/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;

public class ProtectionDomain {
    private CodeSource codeSource;
    private PermissionCollection permissions;

    public ProtectionDomain(CodeSource cs, PermissionCollection permissions) {
        this.codeSource = cs;
        if (permissions != null) {
            permissions.setReadOnly();
            this.permissions = permissions;
        }
    }

    public final CodeSource getCodeSource() {
        return this.codeSource;
    }

    public final PermissionCollection getPermissions() {
        return this.permissions;
    }

    public boolean implies(Permission permission) {
        return this.permissions == null ? false : this.permissions.implies(permission);
    }

    public String toString() {
        String answer = this.getClass().getName() + " with codesource " + this.codeSource;
        return answer;
    }
}

