/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecurityAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;

public class KeyStore {
    private KeyStoreSpi keySpi;
    private Provider provider;
    private String type;

    public static String getDefaultType() {
        return "none";
    }

    public static KeyStore getInstance(String type) throws NoSuchAlgorithmException {
        SecurityAction action = new SecurityAction(type, "KeyStore.");
        return new KeyStore((KeyStoreSpi)action.spi, action.provider, type);
    }

    public static KeyStore getInstance(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityAction action = new SecurityAction(type, provider, "KeyStore.");
        return new KeyStore((KeyStoreSpi)action.spi, action.provider, type);
    }

    public final Enumeration aliases() throws KeyStoreException {
        return this.keySpi.engineAliases();
    }

    public final boolean containsAlias(String alias) throws KeyStoreException {
        return this.keySpi.engineContainsAlias(alias);
    }

    public final void deleteEntry(String alias) throws KeyStoreException {
        this.keySpi.engineDeleteEntry(alias);
    }

    public final Certificate getCertificate(String alias) throws KeyStoreException {
        return this.keySpi.engineGetCertificate(alias);
    }

    public final String getCertificateAlias(Certificate cert) throws KeyStoreException {
        return this.keySpi.engineGetCertificateAlias(cert);
    }

    public final Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        return this.keySpi.engineGetCertificateChain(alias);
    }

    public final Date getCreationDate(String alias) throws KeyStoreException {
        return this.keySpi.engineGetCreationDate(alias);
    }

    public final Key getKey(String alias, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.keySpi.engineGetKey(alias, password);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final boolean isCertificateEntry(String alias) throws KeyStoreException {
        return this.keySpi.engineIsCertificateEntry(alias);
    }

    public final boolean isKeyEntry(String alias) throws KeyStoreException {
        return this.keySpi.engineIsKeyEntry(alias);
    }

    public final void load(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keySpi.engineLoad(stream, password);
    }

    public final void setCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.keySpi.engineSetCertificateEntry(alias, cert);
    }

    public final void setKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        this.keySpi.engineSetKeyEntry(alias, key, chain);
    }

    public final void setKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        this.keySpi.engineSetKeyEntry(alias, key, password, chain);
    }

    public final int size() throws KeyStoreException {
        return this.keySpi.engineSize();
    }

    public final void store(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keySpi.engineStore(stream, password);
    }

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String type) {
        this.keySpi = keyStoreSpi;
        this.provider = provider;
        this.type = type;
    }
}

