/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.Vector;
import wonka.vm.DeprecatedMethodError;
import wonka.vm.SystemTimer;

public class RMIClassLoader {
    private static final String DEFAULT_CODEBASE;
    private static final boolean USE_CODEBASE_ONLY;
    static final Hashtable classLoaders;
    static ReferenceQueue queue;

    private RMIClassLoader() {
    }

    public static String getClassAnnotation(final Class cl) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource cs;
                ProtectionDomain pd = cl.getProtectionDomain();
                if (pd != null && (cs = pd.getCodeSource()) != null) {
                    return cs.getLocation().toString();
                }
                return DEFAULT_CODEBASE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getClassLoader(String codebase) throws MalformedURLException, SecurityException {
        Hashtable hashtable = classLoaders;
        synchronized (hashtable) {
            ClassLoader cl;
            WeakReference ref = (WeakReference)classLoaders.get(codebase);
            if (ref != null && (cl = (ClassLoader)ref.get()) != null) {
                return cl;
            }
            Vector v = new Vector();
            StringTokenizer st = new StringTokenizer(codebase);
            while (st.hasMoreTokens()) {
                v.add(new URL(st.nextToken()));
            }
            URLClassLoader cl2 = new URLClassLoader((URL[])v.toArray(new URL[v.size()]));
            if (queue == null) {
                queue = new ReferenceQueue();
                new CleanupTask();
            }
            classLoaders.put(codebase, new WeakReference(cl2, queue));
            return cl2;
        }
    }

    public static Object getSecurityContext(ClassLoader loader) {
        throw new DeprecatedMethodError("RMIClassLoader.getSecurityContext(java.lang.ClassLoader) is depracted");
    }

    public static Class loadClass(String name) throws MalformedURLException, ClassNotFoundException {
        throw new DeprecatedMethodError("RMIClassLoader.loadClass(java.lang.String) is depracted");
    }

    public static Class loadClass(String codebase, String name) throws MalformedURLException, ClassNotFoundException {
        if (USE_CODEBASE_ONLY) {
            codebase = DEFAULT_CODEBASE;
        }
        return Class.forName(name, true, RMIClassLoader.getClassLoader(codebase));
    }

    public static Class loadClass(URL codebase, String name) throws MalformedURLException, ClassNotFoundException {
        return RMIClassLoader.loadClass(codebase.toString(), name);
    }

    static {
        boolean b = false;
        classLoaders = new Hashtable(11);
        DEFAULT_CODEBASE = System.getProperty("java.rmi.server.codebase");
        try {
            b = Boolean.getBoolean("java.rmi.server.useCodebaseOnly");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        USE_CODEBASE_ONLY = b && DEFAULT_CODEBASE != null;
    }

    private static class CleanupTask
    extends TimerTask {
        public CleanupTask() {
            SystemTimer.scheduleSystemTask(this, 10000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Reference ref = queue.poll();
            while (ref != null) {
                Hashtable hashtable = classLoaders;
                synchronized (hashtable) {
                    Iterator it = classLoaders.entrySet().iterator();
                    try {
                        Map.Entry entry = (Map.Entry)it.next();
                        if (ref == entry.getValue()) {
                            it.remove();
                        }
                    }
                    catch (NoSuchElementException nsee) {
                        // empty catch block
                    }
                    if (classLoaders.size() == 0) {
                        queue = null;
                        this.cancel();
                        break;
                    }
                }
                ref = queue.poll();
            }
        }
    }
}

