/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import wonka.vm.ClassLoaderURLHandler;

public class URLClassLoader
extends SecureClassLoader {
    URL[] urls;
    ClassLoaderURLHandler[] handlers;
    private static final Manifest emptyMan = new Manifest();

    private static void permissionCheck() {
    }

    public URLClassLoader(URL[] urls) throws SecurityException {
        this.handlers = ClassLoaderURLHandler.createClassLoaderURLHandlers(urls);
        this.urls = urls;
    }

    public URLClassLoader(URL[] urls, ClassLoader parent) throws SecurityException {
        super(parent);
        this.handlers = ClassLoaderURLHandler.createClassLoaderURLHandlers(urls);
        this.urls = urls;
    }

    public URLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) throws SecurityException {
        super(parent);
        this.handlers = ClassLoaderURLHandler.createClassLoaderURLHandlers(urls);
        this.urls = urls;
    }

    public static URLClassLoader newInstance(URL[] urls) throws SecurityException {
        URLClassLoader.permissionCheck();
        return new URLClassLoader(urls);
    }

    public static URLClassLoader newInstance(URL[] urls, ClassLoader parent) throws SecurityException {
        URLClassLoader.permissionCheck();
        return new URLClassLoader(urls, parent);
    }

    protected void addURL(URL url) {
        ClassLoaderURLHandler handler = ClassLoaderURLHandler.createClassLoaderURLHandler(url);
        int length = this.handlers.length;
        ClassLoaderURLHandler[] newhandlers = new ClassLoaderURLHandler[length + 1];
        System.arraycopy(this.handlers, 0, newhandlers, 0, length);
        newhandlers[length] = handler;
        this.handlers = newhandlers;
        URL[] newurls = new URL[this.urls.length + 1];
        System.arraycopy(this.urls, 0, newurls, 0, this.urls.length);
        newurls[this.urls.length] = url;
        this.urls = newurls;
    }

    protected Package definePackage(String pname, Manifest man, URL url) throws IllegalArgumentException {
        Attributes attr = man.getMainAttributes();
        String specTitle = attr.getValue("Specification-Title");
        String specVersion = attr.getValue("Specification-Version");
        String specVendor = attr.getValue("Specification-Vendor");
        String implTitle = attr.getValue("Implementation-Title");
        String implVersion = attr.getValue("Implementation-Version");
        String implVendor = attr.getValue("Implementation-Vendor");
        return this.definePackage(pname, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, url);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String filename = name.replace('.', '/') + ".class";
        int l = this.handlers.length;
        for (int i = 0; i < l; ++i) {
            ClassLoaderURLHandler handler = this.handlers[i];
            byte[] bytes = handler.getByteArray(filename);
            if (bytes == null) continue;
            URL url = this.urls[i];
            int idx = name.lastIndexOf(46);
            String pname = name.substring(0, idx == -1 ? 0 : idx);
            if (this.getPackage(pname) == null) {
                this.definePackage(pname, handler.getManifest(), url);
            }
            if (url.getProtocol().equals("jar")) {
                String u = ("" + url).substring(4);
                u = u.substring(0, u.indexOf(33));
                try {
                    url = new URL(u);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return this.defineClass(name, bytes, 0, bytes.length, new CodeSource(url, null));
        }
        throw new ClassNotFoundException(name);
    }

    public URL findResource(String name) {
        int l = this.handlers.length;
        for (int i = 0; i < l; ++i) {
            ClassLoaderURLHandler handler = this.handlers[i];
            URL url = handler.getURL(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Enumeration findResources(String name) throws IOException {
        int l = this.handlers.length;
        Vector v = new Vector(l);
        for (int i = 0; i < l; ++i) {
            ClassLoaderURLHandler handler = this.handlers[i];
            URL url = handler.getURL(name);
            if (url == null) continue;
            v.add(url);
        }
        return v.elements();
    }

    protected PermissionCollection getPermissions(CodeSource codes) {
        PermissionCollection pc = super.getPermissions(codes);
        return pc;
    }

    public URL[] getURLs() {
        return (URL[])this.urls.clone();
    }
}

