/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.GetSystemProperty;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;

public final class URL
implements Serializable {
    private static final long serialVersionUID = -7627629688361524110L;
    private static final char OR = '|';
    private static URLStreamHandlerFactory factory;
    private static Hashtable handlers;
    private String protocol;
    private String fragment;
    private String host = "";
    private int port = -1;
    private String query;
    private String path = "";
    private String authority;
    private int hashCode;
    private transient String userInfo;
    private transient URLStreamHandler streamHandler;

    static void netPermissionCheck(String type) {
    }

    public URL(String location) throws MalformedURLException {
        int hash;
        int colon = location.indexOf(":");
        if (colon < 0) {
            location = "file:" + location;
            colon = location.indexOf(":");
        }
        if ((hash = location.lastIndexOf("#")) < 0) {
            hash = location.length();
        } else {
            this.fragment = location.substring(hash + 1);
        }
        if (location.startsWith("file://") && location.lastIndexOf(47) == 6) {
            this.protocol = "file";
            this.streamHandler = URL.getHandler(this.protocol);
            this.streamHandler.parseURL(this, location, 7, hash);
        } else {
            this.protocol = location.substring(0, colon);
            this.streamHandler = URL.getHandler(this.protocol);
            this.streamHandler.parseURL(this, location, colon + 1, hash);
        }
    }

    public URL(String protocol, String host, String path) throws MalformedURLException {
        this(protocol, host, -1, path, null);
    }

    public URL(String protocol, String host, int port, String File2) throws MalformedURLException {
        this(protocol, host, port, File2, null);
    }

    public URL(String protocol, String host, int port, String File2, URLStreamHandler handler) throws MalformedURLException {
        if (protocol == null || File2 == null) {
            throw new NullPointerException();
        }
        if (host == null) {
            host = "";
        }
        if (port < -1 || port > 65535) {
            throw new MalformedURLException("illegal port specified");
        }
        this.protocol = protocol;
        if (handler == null) {
            this.streamHandler = URL.getHandler(this.protocol);
        } else {
            URL.netPermissionCheck("specifyStreamHandler");
            this.streamHandler = handler;
        }
        this.port = port;
        this.host = host;
        this.path = File2;
    }

    public URL(URL context, String spec) throws MalformedURLException {
        this(context, spec, null);
    }

    public URL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        int i = spec.indexOf(58);
        if (i > -1) {
            this.protocol = spec.substring(0, i);
            if (handler == null) {
                this.streamHandler = URL.getHandler(this.protocol);
            } else {
                URL.netPermissionCheck("specifyStreamHandler");
                this.streamHandler = handler;
            }
            this.streamHandler.parseURL(this, spec, i + 1, spec.length());
            if (this.host == null) {
                this.host = "";
            }
            if (this.path == null) {
                throw new MalformedURLException();
            }
            i = spec.indexOf("#");
            if (i != -1) {
                this.fragment = spec.substring(i + 1);
            }
        } else {
            this.protocol = context.protocol;
            this.host = context.host;
            this.port = context.port;
            if (handler == null) {
                this.streamHandler = URL.getHandler(this.protocol);
            } else {
                URL.netPermissionCheck("specifyStreamHandler");
                this.streamHandler = handler;
            }
            i = spec.indexOf(35);
            if (i != -1) {
                this.path = context.path + spec.substring(0, i);
                this.fragment = spec.substring(i + 1);
            } else {
                this.path = context.path + spec;
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof URL)) {
            return false;
        }
        return this.streamHandler.equals(this, (URL)o);
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class[] classes) throws IOException {
        return this.openConnection().getContent(classes);
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public String getFile() {
        return this.path + (this.query != null ? "?" + this.query : "");
    }

    public String getRef() {
        return this.fragment;
    }

    public String getQuery() {
        return this.query;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.streamHandler.hashCode(this);
        }
        return this.hashCode;
    }

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory newfact) {
        factory = newfact;
    }

    public URLConnection openConnection() throws IOException {
        return this.streamHandler.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public boolean sameFile(URL url) {
        if (url == null) {
            return false;
        }
        return this.streamHandler.sameFile(this, url);
    }

    public String toExternalForm() {
        return this.streamHandler.toExternalForm(this);
    }

    public String toString() {
        return this.streamHandler.toExternalForm(this);
    }

    protected void set(String protocol, String host, int port, String path, String ref) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (host == null) {
            host = "";
        }
        if (port < -1 || port > 65535) {
            throw new IllegalArgumentException();
        }
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        this.fragment = ref;
    }

    protected void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (host == null) {
            host = "";
        }
        if (port < -1 || port > 65535) {
            throw new IllegalArgumentException();
        }
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        this.fragment = ref;
        this.authority = authority;
        this.query = query;
        this.userInfo = userInfo;
    }

    void setHost(String host) {
        if (host == null) {
            host = "";
        }
        this.hashCode = 0;
        this.host = host;
    }

    void setProtocol(String protocol) {
        if (!protocol.equals(this.protocol)) {
            this.streamHandler = null;
            this.hashCode = 0;
            this.protocol = protocol;
        }
    }

    void setFile(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.hashCode = 0;
        this.path = path;
    }

    void setRef(String ref) {
        this.fragment = ref;
    }

    void setQuery(String query) {
        this.query = query;
    }

    void setPort(int port) {
        if (port < -1 || port > 65535) {
            throw new IllegalArgumentException();
        }
        this.port = port;
    }

    private static synchronized URLStreamHandler getHandler(String protocol) throws MalformedURLException {
        URLStreamHandler handler = null;
        if (handlers == null) {
            handlers = new Hashtable(11);
        } else {
            handler = (URLStreamHandler)handlers.get(protocol);
        }
        if (handler != null) {
            return handler;
        }
        if (factory != null) {
            handler = factory.createURLStreamHandler(protocol);
            handlers.put(protocol, handler);
            return handler;
        }
        String pkgs = GetSystemProperty.PROTOCOL_HANDLER_PKGS;
        while (pkgs.length() > 0) {
            String name;
            int i = pkgs.indexOf(124);
            if (i == -1) {
                name = pkgs;
                pkgs = "";
            } else {
                name = pkgs.substring(0, i);
                pkgs = pkgs.substring(i + 1);
            }
            name = name + "." + protocol + ".Handler";
            try {
                handler = (URLStreamHandler)Class.forName(name, true, ClassLoader.getSystemClassLoader()).newInstance();
                handlers.put(protocol, handler);
                return handler;
            }
            catch (Exception e) {
            }
        }
        throw new MalformedURLException("no Handler found for the " + protocol + " protocol");
    }
}

