/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;

public class Socket {
    private static SocketImplFactory factory = null;
    SocketImpl socket;
    private InetAddress local = null;

    protected Socket() {
        this.socket = this.getImpl();
    }

    protected Socket(SocketImpl impl) throws SocketException {
        if (impl == null) {
            throw new NullPointerException();
        }
        this.socket = impl;
    }

    public Socket(String host, int port) throws UnknownHostException, IOException {
        this(InetAddress.getByName(host), port, null, 0);
    }

    public Socket(InetAddress address, int port) throws IOException {
        this(address, port, null, 0);
    }

    public Socket(String host, int port, InetAddress localAddr, int localPort) throws UnknownHostException, IOException {
        this(InetAddress.getByName(host), port, localAddr, localPort);
    }

    public Socket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        if (port < 0 || port > 65535 || localPort < 0 || localPort > 65535) {
            throw new IllegalArgumentException();
        }
        if (localAddr == null) {
            localAddr = InetAddress.allZeroAddress;
        }
        InetAddress.connectCheck(address.getHostAddress(), port);
        this.socket = this.getImpl();
        this.socket.create(true);
        this.socket.bind(localAddr, localPort);
        this.socket.connect(address, port);
    }

    private SocketImpl getImpl() {
        return factory == null ? new PlainSocketImpl() : factory.createSocketImpl();
    }

    public Socket(InetAddress host, int port, boolean stream) throws IOException {
        this(host, port);
    }

    public Socket(String host, int port, boolean stream) throws IOException {
        this(host, port);
    }

    public synchronized void close() throws IOException {
        this.socket.close();
    }

    public InetAddress getInetAddress() {
        return this.socket.address;
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public InetAddress getLocalAddress() {
        if (this.local == null) {
            try {
                this.local = (InetAddress)this.socket.getOption(15);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
        return this.local;
    }

    public int getLocalPort() {
        return this.socket.localport;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public int getPort() {
        return this.socket.port;
    }

    public int getReceiveBufferSize() throws SocketException {
        return (Integer)this.socket.getOption(4098);
    }

    public int getSendBufferSize() throws SocketException {
        return (Integer)this.socket.getOption(4097);
    }

    public int getSoLinger() throws SocketException {
        try {
            return (Integer)this.socket.getOption(128);
        }
        catch (ClassCastException cce) {
            return -1;
        }
    }

    public int getSoTimeout() throws SocketException {
        return (Integer)this.socket.getOption(4102);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return (Boolean)this.socket.getOption(1);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.socket.setOption(4098, new Integer(size));
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.socket.setOption(4097, new Integer(size));
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (on) {
            if (linger < 0) {
                throw new IllegalArgumentException();
            }
            this.socket.setOption(128, new Integer(linger));
        } else {
            this.socket.setOption(128, new Boolean(false));
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        this.socket.setOption(4102, new Integer(timeout));
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setOption(1, new Boolean(on));
    }

    public String toString() {
        return "Socket to " + this.socket;
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory fact) throws IOException {
        if (factory != null) {
            throw new SocketException();
        }
        InetAddress.factoryCheck();
        factory = fact;
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setOption(8, new Boolean(on));
    }

    public boolean getKeepAlive() throws SocketException {
        return (Boolean)this.socket.getOption(8);
    }
}

