/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.GetSystemProperty;
import java.net.InetAddress;
import java.net.PlainDatagramSocketImpl;
import java.net.SocketException;

public class MulticastSocket
extends DatagramSocket {
    public MulticastSocket() throws IOException {
        this(0);
    }

    public MulticastSocket(int port) throws IOException {
        super(true);
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        InetAddress.listenCheck(port);
        if (DatagramSocket.theFactory != null) {
            this.dsocket = DatagramSocket.theFactory.createDatagramSocketImpl();
        } else {
            String s = "java.net." + GetSystemProperty.IMPL_PREFIX + "DatagramSocketImpl";
            try {
                this.dsocket = (DatagramSocketImpl)Class.forName(s).newInstance();
            }
            catch (Exception e) {
                this.dsocket = new PlainDatagramSocketImpl();
            }
        }
        this.dsocket.create();
        this.dsocket.setOption(4, new Integer(1));
        this.dsocket.bind(port, InetAddress.allZeroAddress);
    }

    public InetAddress getInterface() throws SocketException {
        return (InetAddress)this.dsocket.getOption(16);
    }

    private static void multicastCheck(InetAddress addr, byte ttl) {
    }

    public void joinGroup(InetAddress groupAddr) throws IOException {
        DatagramSocket.multicastCheck(groupAddr);
        this.dsocket.join(groupAddr);
    }

    public void leaveGroup(InetAddress groupAddr) throws IOException {
        DatagramSocket.multicastCheck(groupAddr);
        this.dsocket.leave(groupAddr);
    }

    public synchronized void send(DatagramPacket dgram, byte ttl) throws IOException {
        InetAddress dest = dgram.getAddress();
        if (dest.isMulticastAddress()) {
            MulticastSocket.multicastCheck(dest, ttl);
            if (!(this.remoteAddress == null || this.remoteAddress.equals(dest) && this.remoteport == dgram.getPort())) {
                throw new IllegalArgumentException("packet has wrong destination ...");
            }
            byte oldttl = this.getTTL();
            this.setTTL(ttl);
            this.dsocket.send(dgram);
            this.setTTL(oldttl);
        } else {
            this.send(dgram);
        }
    }

    public void setInterface(InetAddress addr) throws SocketException {
        this.dsocket.setOption(16, addr);
    }

    public byte getTTL() throws IOException {
        return (byte)this.dsocket.getTimeToLive();
    }

    public void setTTL(byte ttl) throws IOException {
        this.dsocket.setTimeToLive(0xFF & ttl);
    }

    public int getTimeToLive() throws IOException {
        return this.dsocket.getTimeToLive();
    }

    public void setTimeToLive(int ttl) throws IOException {
        this.dsocket.setTimeToLive(ttl);
    }
}

