/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class InetAddress
implements Serializable {
    private static final long serialVersionUID = 3286316764910316507L;
    private static final int TYPE_LOOPBACK = 1;
    private static final int TYPE_IPV4 = 2;
    private static final int TYPE_IPV6 = 10;
    private static InetAddress ownAddress;
    private static final Hashtable addresses;
    static final InetAddress loopbackAddress;
    static final InetAddress allZeroAddress;
    private int family;
    private int address;
    private String hostName;
    private transient String addressCache;

    static void permissionCheck(String host) {
    }

    static void factoryCheck() {
    }

    static void listenCheck(int port) {
    }

    static void acceptCheck(String host, int port) {
    }

    static void connectCheck(String host, int port) {
    }

    InetAddress() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress(int ip, String name, String ipname, int type) {
        this.address = ip;
        this.family = type;
        this.hostName = name;
        this.addressCache = ipname;
        Hashtable hashtable = addresses;
        synchronized (hashtable) {
            addresses.put(name, this);
            addresses.put(ipname, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress(String name) throws UnknownHostException {
        char char0 = name.charAt(0);
        if (char0 >= '0' && char0 <= '9') {
            StringTokenizer s = new StringTokenizer(name, ".");
            if (s.countTokens() == 4) {
                try {
                    for (int i = 0; i < 4; ++i) {
                        int octet = Integer.parseInt(s.nextToken());
                        if (octet < 0 || octet > 255) {
                            throw new UnknownHostException();
                        }
                        this.address = octet + (this.address << 8);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new UnknownHostException();
                }
            }
            this.family = 2;
            Hashtable hashtable = addresses;
            synchronized (hashtable) {
                addresses.put(this.getHostAddress(), this);
                addresses.put(name, this);
            }
        }
        this.createInetAddress(name);
        Hashtable hashtable = addresses;
        synchronized (hashtable) {
            addresses.put(this.getHostName(), this);
            addresses.put(this.getHostAddress(), this);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InetAddress)) {
            return false;
        }
        InetAddress other = (InetAddress)obj;
        return this.address == other.address;
    }

    public byte[] getAddress() {
        byte[] octets = new byte[4];
        octets[3] = (byte)this.address;
        octets[2] = (byte)(this.address >>> 8);
        octets[1] = (byte)(this.address >>> 16);
        octets[0] = (byte)(this.address >>> 24);
        return octets;
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            throw new UnknownHostException();
        }
        InetAddress[] temp = new InetAddress[]{InetAddress.getByName(host)};
        return temp;
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        if (host == null) {
            return loopbackAddress;
        }
        try {
            InetAddress.permissionCheck(host);
        }
        catch (IllegalArgumentException iae) {
            throw new UnknownHostException(host);
        }
        Object cached = addresses.get(host.toLowerCase());
        if (cached != null) {
            return (InetAddress)cached;
        }
        return new InetAddress(host);
    }

    public String getHostAddress() {
        if (this.addressCache == null) {
            this.addressCache = InetAddress.intToIPString(this.address);
        }
        return this.addressCache;
    }

    private static String intToIPString(int address) {
        StringBuffer result = new StringBuffer(16);
        result.append(address >>> 24 & 0xFF);
        result.append('.');
        result.append(address >>> 16 & 0xFF);
        result.append('.');
        result.append(address >>> 8 & 0xFF);
        result.append('.');
        result.append(address & 0xFF);
        return result.toString();
    }

    static InetAddress createInetAddress(int ip) {
        String ipname = InetAddress.intToIPString(ip);
        Object address = addresses.get(ipname);
        if (address == null) {
            try {
                return new InetAddress(ipname);
            }
            catch (UnknownHostException uhe) {
                return new InetAddress(ip, ipname, ipname, 2);
            }
        }
        return (InetAddress)address;
    }

    public String getHostName() {
        if (this.hostName == null) {
            if (this.getHostAddress() != null && this.lookupName()) {
                this.hostName = this.addressCache;
            } else {
                addresses.put(this.hostName, this);
            }
        }
        InetAddress.permissionCheck(this.hostName);
        return this.hostName;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        try {
            InetAddress.permissionCheck(InetAddress.getLocalName());
            return ownAddress;
        }
        catch (SecurityException se) {
            return loopbackAddress;
        }
    }

    public int hashCode() {
        return this.address;
    }

    public boolean isMulticastAddress() {
        byte[] ip = this.getAddress();
        return (ip[0] & 0xFF) > 223 && (ip[0] & 0xFF) < 240;
    }

    public String toString() {
        return this.getHostName() + "/" + this.getHostAddress();
    }

    private native boolean lookupName();

    private native void createInetAddress(String var1) throws UnknownHostException;

    private static native String getLocalName();

    static {
        addresses = new Hashtable();
        loopbackAddress = new InetAddress(2130706433, "localhost", "127.0.0.1", 1);
        allZeroAddress = new InetAddress(0, "0.0.0.0", "0.0.0.0", 2);
        try {
            ownAddress = new InetAddress(InetAddress.getLocalName());
        }
        catch (UnknownHostException uhe) {
            ownAddress = loopbackAddress;
        }
        addresses.put("loopback", loopbackAddress);
    }
}

