/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.GetSystemProperty;
import java.net.InetAddress;
import java.net.PlainDatagramSocketImpl;
import java.net.SocketException;

public class DatagramSocket {
    private DatagramPacket peekGarbage;
    DatagramSocketImpl dsocket;
    InetAddress remoteAddress = null;
    int remoteport = -1;
    static DatagramSocketImplFactory theFactory;

    public static void setDatagramSocketImplFactory(DatagramSocketImplFactory factory) throws IOException {
        if (theFactory != null) {
            throw new SocketException();
        }
        InetAddress.factoryCheck();
        theFactory = factory;
    }

    static void multicastCheck(InetAddress addr) {
    }

    DatagramSocket(boolean Multicast) {
    }

    public DatagramSocket() throws SocketException, SecurityException {
        this(0, null);
    }

    public DatagramSocket(int port) throws SocketException, SecurityException {
        this(port, null);
    }

    public DatagramSocket(int port, InetAddress laddr) throws SocketException, SecurityException {
        if (laddr == null) {
            laddr = InetAddress.allZeroAddress;
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        InetAddress.listenCheck(port);
        if (theFactory != null) {
            this.dsocket = theFactory.createDatagramSocketImpl();
        } else {
            String s = "java.net." + GetSystemProperty.IMPL_PREFIX + "DatagramSocketImpl";
            try {
                this.dsocket = (DatagramSocketImpl)Class.forName(s).newInstance();
            }
            catch (Exception e) {
                this.dsocket = new PlainDatagramSocketImpl();
            }
        }
        this.dsocket.create();
        this.dsocket.bind(port, laddr);
    }

    public void connect(InetAddress address, int port) throws SecurityException {
        if (address == null || port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        if (address.isMulticastAddress()) {
            DatagramSocket.multicastCheck(address);
        } else {
            InetAddress.connectCheck(address.getHostAddress(), port);
        }
        this.remoteAddress = address;
        this.remoteport = port;
    }

    public void disconnect() {
        this.remoteAddress = null;
        this.remoteport = -1;
    }

    public InetAddress getInetAddress() {
        return this.remoteAddress;
    }

    public int getPort() {
        return this.remoteport;
    }

    public void send(DatagramPacket p) throws IOException {
        if (this.remoteAddress == null) {
            InetAddress addr = p.getAddress();
            if (addr.isMulticastAddress()) {
                DatagramSocket.multicastCheck(addr);
            } else {
                InetAddress.connectCheck(addr.getHostAddress(), p.getPort());
            }
        } else if (!this.remoteAddress.equals(p.getAddress()) || this.remoteport != p.getPort()) {
            throw new IllegalArgumentException("packet has wrong destination");
        }
        this.dsocket.send(p);
    }

    public synchronized void receive(DatagramPacket p) throws IOException {
        block7: {
            if (this.remoteAddress == null) {
                while (true) {
                    this.dsocket.receive(p);
                    try {
                        InetAddress.acceptCheck(p.getAddress().getHostName(), p.getPort());
                        break block7;
                    }
                    catch (SecurityException se) {
                        continue;
                    }
                    break;
                }
            }
            if (p == null) {
                throw new NullPointerException();
            }
            if (this.peekGarbage == null) {
                this.peekGarbage = new DatagramPacket(new byte[2], 2);
            }
            InetAddress inAddr = new InetAddress();
            int prt = 0;
            while (this.remoteport != (prt = this.dsocket.peek(inAddr)) || !inAddr.equals(this.remoteAddress)) {
                this.dsocket.receive(this.peekGarbage);
            }
            this.dsocket.receive(p);
        }
    }

    public InetAddress getLocalAddress() {
        try {
            InetAddress addr = (InetAddress)this.dsocket.getOption(15);
            InetAddress.connectCheck(addr.getHostName(), -1);
            return addr;
        }
        catch (SocketException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return InetAddress.loopbackAddress;
    }

    public int getLocalPort() {
        return this.dsocket.localPort;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        this.dsocket.setOption(4102, new Integer(timeout));
    }

    public synchronized int getSoTimeout() throws SocketException {
        return (Integer)this.dsocket.getOption(4102);
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("size should be > 0, but got " + size);
        }
        this.dsocket.setOption(4097, new Integer(size));
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return (Integer)this.dsocket.getOption(4097);
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("size should be > 0, but got " + size);
        }
        this.dsocket.setOption(4098, new Integer(size));
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return (Integer)this.dsocket.getOption(4098);
    }

    public void close() {
        this.dsocket.close();
    }
}

