/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import wonka.io.ErrorOutputStream;
import wonka.io.StandardInputStream;
import wonka.io.StandardOutputStream;
import wonka.vm.Etc;
import wonka.vm.Wonka;

public final class System {
    public static InputStream in;
    public static PrintStream out;
    public static PrintStream err;
    private static SecurityManager theSecurityManager;
    private static Runtime theRuntime;
    private static Properties systemProperties;
    private static boolean initialized;

    private static native String[] getCmdLineProperties();

    private static void parseCmdLineProperties() {
        String[] props = System.getCmdLineProperties();
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                String key;
                int equals_at = props[i].indexOf(61);
                if (equals_at < 0) {
                    key = props[i];
                    Etc.woempa(10, "SystemInit: Setting system property '" + key + "' to \"\"");
                    systemProperties.put(key, "");
                    continue;
                }
                if (equals_at == 0) {
                    Etc.woempa(10, "SystemInit: Ignoring nameless property in " + props[i]);
                    continue;
                }
                if (equals_at == props[i].length() - 1) {
                    key = props[i].substring(0, equals_at);
                    Etc.woempa(10, "SystemInit: Setting system property '" + key + "' to \"\"");
                    systemProperties.put(key, "");
                    continue;
                }
                key = props[i].substring(0, equals_at);
                String value = props[i].substring(equals_at + 1);
                Etc.woempa(10, "SystemInit: Setting system property '" + key + "' to '" + value + "'");
                systemProperties.put(key, value);
            }
        }
    }

    private static Properties createDefaultProperties() {
        Properties systemDefaultProperties = new Properties();
        systemDefaultProperties.put("java.version", "1.3");
        systemDefaultProperties.put("java.vendor", "ACUNIA");
        systemDefaultProperties.put("java.vendor.url", "http://www.acunia.com");
        systemDefaultProperties.put("java.home", Etc.getInstallationDir() + "/");
        systemDefaultProperties.put("java.vm.version", Etc.getVersion());
        systemDefaultProperties.put("java.vm.vendor", "ACUNIA");
        systemDefaultProperties.put("java.vm.name", "Wonka");
        systemDefaultProperties.put("java.class.version", "46.0");
        systemDefaultProperties.put("java.class.path", "");
        systemDefaultProperties.put("java.ext.dirs", Etc.getInstallationDir() + "/ext/");
        systemDefaultProperties.put("os.name", Etc.getOSName());
        systemDefaultProperties.put("os.arch", Etc.getOSArch());
        systemDefaultProperties.put("os.version", Etc.getOSVersion());
        systemDefaultProperties.put("file.separator", "/");
        systemDefaultProperties.put("file.encoding", "8859_1");
        systemDefaultProperties.put("path.separator", ":");
        systemDefaultProperties.put("line.separator", "\n");
        systemDefaultProperties.put("user.name", Etc.getUserName());
        systemDefaultProperties.put("user.home", Etc.getUserHome());
        systemDefaultProperties.put("user.dir", Etc.getUserDir());
        systemDefaultProperties.put("user.language", "en");
        return systemDefaultProperties;
    }

    public static void setIn(InputStream newIn) {
        if (in != null) {
            try {
                Etc.woempa(9, "setIn: closing " + in);
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        in = newIn;
    }

    public static void setOut(PrintStream newOut) {
        if (out != null) {
            Etc.woempa(9, "setOut: closing " + in);
            out.close();
        }
        out = newOut;
    }

    public static void setErr(PrintStream newErr) {
        if (err != null) {
            Etc.woempa(9, "setErr: closing " + in);
            err.close();
        }
        err = newErr;
    }

    public static SecurityManager getSecurityManager() {
        return theSecurityManager;
    }

    public static void setSecurityManager(SecurityManager sm) throws SecurityException {
        if (theSecurityManager != null) {
            // empty if block
        }
        theSecurityManager = sm;
    }

    public static native long currentTimeMillis();

    private static void propertyCheck(String propname) {
    }

    private static void propertiesCheck() {
    }

    public static Properties getProperties() throws SecurityException {
        System.propertiesCheck();
        return systemProperties;
    }

    public static void setProperties(Properties props) throws SecurityException {
        System.propertiesCheck();
        systemProperties = props;
    }

    public static String getProperty(String key) throws SecurityException {
        System.propertyCheck(key);
        try {
            return systemProperties.getProperty(key);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public static String getProperty(String key, String defaults) throws SecurityException {
        System.propertyCheck(key);
        try {
            return systemProperties.getProperty(key, defaults);
        }
        catch (NullPointerException npe) {
            return defaults;
        }
    }

    public static String setProperty(String key, String defaults) throws SecurityException {
        return (String)systemProperties.setProperty(key, defaults);
    }

    public static void exit(int status) throws SecurityException {
        theRuntime.exit(status);
    }

    public static void gc() {
        theRuntime.gc();
    }

    public static void runFinalization() {
        theRuntime.runFinalization();
    }

    public static void load(String libname) throws SecurityException, UnsatisfiedLinkError {
        throw new UnsatisfiedLinkError("not implemented");
    }

    public static void loadLibrary(String libname) throws SecurityException, UnsatisfiedLinkError {
        Runtime.getRuntime().loadLibrary(libname);
    }

    public static String mapLibraryName(String libname) {
        return "lib" + libname + ".so";
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4) throws NullPointerException, ArrayStoreException, ArrayIndexOutOfBoundsException;

    public static native int identityHashCode(Object var0);

    static {
        theRuntime = Runtime.getRuntime();
        systemProperties = new Properties(System.createDefaultProperties());
        try {
            InputStream syspropstream = ClassLoader.getSystemResourceAsStream("system.properties");
            systemProperties.load(syspropstream);
        }
        catch (IOException e) {
            // empty catch block
        }
        System.parseCmdLineProperties();
        try {
            in = new StandardInputStream();
            boolean system_out_autoflush = Boolean.valueOf(Wonka.getProperty("wonka.out.autoflush", "true"));
            out = new PrintStream(new StandardOutputStream(), system_out_autoflush);
            boolean system_err_autoflush = Boolean.valueOf(Wonka.getProperty("wonka.err.autoflush", "true"));
            err = new PrintStream(new ErrorOutputStream(), system_err_autoflush);
            ClassLoader.get_defaultProtectionDomain();
            ClassLoader.createApplicationClassLoader();
            Locale.setDefault(new Locale(System.getProperty("user.language", "en"), System.getProperty("user.country", "")));
            TimeZone.setDefault(null);
            String theManager = System.getProperty("java.security.manager");
            if ("".equals(theManager) || "default".equals(theManager)) {
                theSecurityManager = new SecurityManager();
            }
            initialized = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!initialized) {
            System.exit(1);
        }
    }
}

