/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.net.URL;
import wonka.vm.SystemClassLoader;

public class Package {
    private String name;
    private boolean defined;
    private String spectitle;
    private String specvendor;
    private String specversion;
    private String impltitle;
    private String implvendor;
    private String implversion;
    private URL sealbase;

    Package(String name, String spectitle, String specversion, String specvendor, String impltitle, String implversion, String implvendor, URL sealbase) {
        this.name = name;
        this.defined = true;
        this.spectitle = spectitle;
        this.specversion = specversion;
        this.specvendor = specvendor;
        this.impltitle = impltitle;
        this.implversion = implversion;
        this.implvendor = implvendor;
        this.sealbase = sealbase;
    }

    Package(String name) {
        this.name = name;
        this.defined = false;
    }

    public String getImplementationTitle() {
        return this.impltitle;
    }

    public String getImplementationVendor() {
        return this.implvendor;
    }

    public String getImplementationVersion() {
        return this.implversion;
    }

    public String getSpecificationTitle() {
        return this.spectitle;
    }

    public String getSpecificationVendor() {
        return this.specvendor;
    }

    public String getSpecificationVersion() {
        return this.specversion;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSealed() {
        return this.sealbase != null;
    }

    public boolean isSealed(URL sealer) {
        return this.sealbase == sealer;
    }

    public boolean isCompatibleWith(String target) throws NumberFormatException {
        String this_remainder = this.specversion;
        String that_remainder = target;
        while (this_remainder.length() > 0 || that_remainder.length() > 0) {
            int this_dot = this_remainder.indexOf(46);
            int this_component = this_dot >= 0 ? Integer.parseInt(this_remainder.substring(0, this_dot)) : 0;
            this_remainder = this_remainder.substring(this_dot + 1);
            int that_dot = that_remainder.indexOf(46);
            int that_component = that_dot >= 0 ? Integer.parseInt(that_remainder.substring(0, that_dot)) : 0;
            that_remainder = that_remainder.substring(that_dot + 1);
            if (this_component == that_component) continue;
            return this_component > that_component;
        }
        return true;
    }

    public static Package getPackage(String name) {
        ClassLoader cl = ClassLoader.getCallingClassLoader();
        if (cl == null) {
            cl = SystemClassLoader.getInstance();
        }
        return cl.getPackage(name);
    }

    public static Package[] getPackages() {
        ClassLoader cl = ClassLoader.getCallingClassLoader();
        if (cl == null) {
            cl = SystemClassLoader.getInstance();
        }
        return cl.getPackages();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "package " + this.name + (this.spectitle != null ? " " + this.spectitle : "") + (this.specversion != null ? " " + this.specversion : "");
    }
}

