/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable {
    private static final long serialVersionUID = -7183698231559129828L;
    public static final byte MAX_VALUE = 127;
    public static final byte MIN_VALUE = -128;
    public static final Class TYPE = Byte.getWrappedClass();
    private final byte value;

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String str) throws NumberFormatException {
        this.value = Byte.parseByte(str);
    }

    public byte byteValue() {
        return this.value;
    }

    public static Byte decode(String nm) throws NumberFormatException {
        int sign = 1;
        int skip = 0;
        int radix = 10;
        String str = "";
        if (nm.startsWith("-")) {
            sign = -1;
            skip = 1;
            str = "-";
        }
        if (nm.substring(skip).startsWith("0x")) {
            radix = 16;
            if (nm.substring(skip += 2).startsWith("-")) {
                throw new NumberFormatException("wrong position of sign");
            }
        } else if (nm.substring(skip).startsWith("#")) {
            radix = 16;
            if (nm.substring(++skip).startsWith("-")) {
                throw new NumberFormatException("wrong position of sign");
            }
        } else if (nm.substring(skip).startsWith("0")) {
            radix = 8;
            if (nm.substring(++skip).startsWith("-")) {
                throw new NumberFormatException("wrong position of sign");
            }
        }
        return new Byte(Byte.parseByte(str.concat(nm.substring(skip)), radix));
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Byte && this.value == ((Byte)obj).intValue();
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public static byte parseByte(String s, int radix) throws NumberFormatException {
        long j = Long.parseLong(s, radix);
        if (j < -128L || j > 127L) {
            throw new NumberFormatException();
        }
        return (byte)j;
    }

    public static byte parseByte(String str) throws NumberFormatException {
        return Byte.parseByte(str, 10);
    }

    public short shortValue() {
        return this.value;
    }

    public int compareTo(Byte anotherByte) {
        int answer = 0;
        if (this.byteValue() != anotherByte.byteValue()) {
            answer = this.value > anotherByte ? 1 : -1;
        }
        return answer;
    }

    public int compareTo(Object o) {
        if (o instanceof Byte) {
            return this.compareTo((Byte)o);
        }
        throw new ClassCastException("Can only compare Byte with Byte");
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String toString(byte value) {
        return String.valueOf(value);
    }

    public static Byte valueOf(String str) throws NumberFormatException {
        return new Byte(str);
    }

    public static Byte valueOf(String str, int radix) throws NumberFormatException {
        return new Byte(Byte.parseByte(str, radix));
    }

    private static native Class getWrappedClass();
}

