/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StreamTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    public int ttype;
    public double nval;
    public String sval;
    private Type[] types;
    private Type defaultType;
    private boolean cppstyle;
    private boolean cstyle;
    private boolean eolSign;
    private boolean tolower;
    private int lineNr;
    private boolean pushback;
    private boolean eof;
    private PushbackReader buffer;

    public void commentChar(int ch) {
        if (ch >= 0 && ch <= 255) {
            this.types[ch].comment = true;
        }
    }

    public void eolIsSignificant(boolean eolSignificant) {
        this.eolSign = eolSignificant;
    }

    public int lineno() {
        return this.lineNr;
    }

    public void lowerCaseMode(boolean lower) {
        this.tolower = lower;
    }

    private final int readChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int ch = this.buffer.read();
        return ch;
    }

    private final void unreadChar(int ch) throws IOException {
        if (ch == -1) {
            this.eof = true;
        } else {
            this.buffer.unread(ch);
        }
    }

    public int nextToken() throws IOException {
        boolean possible_c = false;
        boolean possible_cpp = false;
        if (!this.pushback) {
            this.sval = "";
            int ch = this.readChar();
            if (ch == 47) {
                int ch2 = this.readChar();
                if (ch2 == 42) {
                    possible_c = true;
                }
                if (ch2 == 47) {
                    possible_cpp = true;
                }
                this.unreadChar(ch2);
            }
            Type t = this.getType(ch);
            if (t.quote) {
                this.handleQuote(ch);
            } else {
                if (t.white) {
                    return this.handleWhite(ch);
                }
                if (t.digit) {
                    this.handleDigit(ch);
                } else if (t.word) {
                    this.handleWord(ch);
                } else if (possible_cpp && this.cppstyle) {
                    this.handleCPPComment(ch);
                } else if (possible_c && this.cstyle) {
                    this.handleCComment(ch);
                    this.nextToken();
                } else if (t.comment) {
                    this.handleComment(ch);
                } else if (ch < 256 || ch < 0) {
                    this.sval = null;
                    this.ttype = ch;
                } else {
                    this.sval = "" + (char)ch;
                    this.ttype = -3;
                }
            }
        } else {
            this.pushback = false;
        }
        return this.ttype;
    }

    private final int handleWhite(int ch) throws IOException {
        do {
            if (ch == 13 || ch == 10) {
                int ch2;
                ++this.lineNr;
                if (ch == 13 && (ch2 = this.readChar()) != 10) {
                    this.unreadChar(ch2);
                }
                if (this.eolSign) {
                    this.ttype = 10;
                    this.sval = null;
                    return this.ttype;
                }
            }
            ch = this.readChar();
        } while (this.getType((int)ch).white && ch != -1);
        this.unreadChar(ch);
        return this.nextToken();
    }

    private final void handleWord(int ch) throws IOException {
        this.sval = "";
        while (this.getType((int)ch).word || this.getType((int)ch).digit) {
            this.sval = this.sval + (char)ch;
            ch = this.readChar();
        }
        this.unreadChar(ch);
        this.ttype = -3;
        if (this.tolower) {
            this.sval = this.sval.toLowerCase();
        }
    }

    private final void handleDigit(int ch) throws IOException {
        int n = 0;
        if (ch == 46) {
            n = 1;
        }
        int dots = n;
        this.sval = "";
        this.ttype = -2;
        while (this.getType((int)ch).digit && dots < 2) {
            this.sval = this.sval + (char)ch;
            ch = this.readChar();
            if (ch == 46) {
                ++dots;
            }
            if (ch == 45) break;
        }
        this.unreadChar(ch);
        try {
            this.nval = Double.parseDouble(this.sval);
        }
        catch (NumberFormatException x) {
            if (this.sval.equals("-")) {
                this.ttype = 45;
            }
            this.nval = this.sval.equals(".") ? 0.0 : -0.0;
        }
    }

    private final void handleComment(int ch) throws IOException {
        while (ch != 13 && ch != 10 && ch != -1) {
            ch = this.readChar();
        }
        if (ch != -1) {
            this.unreadChar(ch);
        }
        this.nextToken();
    }

    private final void handleCComment(int ch) throws IOException {
        ch = this.readChar();
        while (true) {
            int ch2;
            if ((ch = this.readChar()) == 42) {
                ch2 = this.readChar();
                if (ch2 == 47) break;
                this.unreadChar(ch2);
                continue;
            }
            if (ch == -1) break;
            if (ch != 13 && ch != 10) continue;
            ++this.lineNr;
            if (ch != 13 || (ch2 = this.readChar()) == 10) continue;
            this.unreadChar(ch2);
        }
    }

    private final void handleCPPComment(int ch) throws IOException {
        ch = this.readChar();
        this.handleComment(ch);
    }

    private final void handleQuote(int ch) throws IOException {
        this.ttype = ch;
        this.sval = "";
        ch = this.readChar();
        while (ch != this.ttype && ch != -1 && ch != 10 && ch != 13) {
            if (ch == 92) {
                ch = this.readChar();
                switch (ch) {
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                }
            }
            this.sval = this.sval + (char)ch;
            ch = this.readChar();
        }
        if (ch == 13 || ch == 10) {
            this.unreadChar(ch);
        }
    }

    public void ordinaryChar(int ch) {
        if (ch >= 0 && ch <= 255) {
            this.types[ch].comment = false;
            this.types[ch].quote = false;
            this.types[ch].digit = false;
            this.types[ch].word = false;
            this.types[ch].white = false;
        }
    }

    public void ordinaryChars(int lo, int hi) {
        if (lo < 0) {
            lo = 0;
        }
        if (hi > 255) {
            hi = 255;
        }
        int i = lo;
        while (i <= hi) {
            this.ordinaryChar(i);
            ++i;
        }
    }

    public void parseNumbers() {
        int ch = 48;
        while (ch <= 57) {
            this.types[ch].digit = true;
            ++ch;
        }
        this.types[46].digit = true;
        this.types[45].digit = true;
    }

    public void pushBack() {
        this.pushback = true;
    }

    public void quoteChar(int ch) {
        if (ch >= 0 && ch <= 255) {
            this.types[ch].quote = true;
        }
    }

    public void resetSyntax() {
        this.ordinaryChars(0, 255);
    }

    public void slashSlashComments(boolean cpp) {
        this.cppstyle = cpp;
    }

    public void slashStarComments(boolean cpp) {
        this.cstyle = cpp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("StreamTokenizer: line = ");
        buf.append("" + this.lineNr);
        buf.append(" last token :'");
        switch (this.ttype) {
            case -3: {
                buf.append(this.sval);
                break;
            }
            case -2: {
                buf.append(this.nval);
                break;
            }
            case -1: {
                buf.append("EOF");
                break;
            }
            case 10: {
                buf.append("EOL");
                break;
            }
            default: {
                buf.append((char)this.ttype);
            }
        }
        buf.append('\'');
        return buf.toString();
    }

    public void whitespaceChars(int lo, int hi) {
        if (lo >= 0 && lo <= 255 && hi >= 0 && hi <= 255) {
            int i = lo;
            while (i <= hi) {
                this.types[i].white = true;
                ++i;
            }
        }
    }

    public void wordChars(int lo, int hi) {
        if (lo >= 0 && lo <= 255 && hi >= 0 && hi <= 255) {
            int i = lo;
            while (i <= hi) {
                this.types[i].word = true;
                ++i;
            }
        }
    }

    private final Type getType(int ch) {
        if (ch >= 0 && ch <= 255) {
            return this.types[ch];
        }
        return this.defaultType;
    }

    private final /* synthetic */ void this() {
        this.defaultType = new Type();
        this.cppstyle = false;
        this.cstyle = false;
        this.eolSign = false;
        this.tolower = false;
        this.lineNr = 1;
        this.pushback = false;
        this.eof = false;
    }

    public StreamTokenizer(Reader reader) {
        this.this();
        this.buffer = new PushbackReader(new BufferedReader(reader));
        this.types = new Type[256];
        int i = 0;
        while (i < 256) {
            this.types[i] = new Type();
            ++i;
        }
        this.commentChar(47);
        this.parseNumbers();
        this.quoteChar(39);
        this.quoteChar(34);
        this.whitespaceChars(0, 32);
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(160, 255);
    }

    public StreamTokenizer(InputStream is) {
        this(new InputStreamReader(is));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Type {
        public boolean comment;
        public boolean quote;
        public boolean digit;
        public boolean word;
        public boolean white;

        private final /* synthetic */ void this() {
            this.comment = false;
        }

        private Type() {
            this.this();
        }
    }
}

