/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    public PushbackInputStream(InputStream in) {
        this(in, 1);
    }

    public PushbackInputStream(InputStream in, int size) {
        super(in);
        this.pos = size;
        this.buf = new byte[size];
    }

    public void close() throws IOException {
        if (this.buf != null) {
            this.in.close();
            this.buf = null;
        }
    }

    public int read() throws IOException {
        if (this.buf == null) {
            throw new IOException("STREAM IS CLOSED");
        }
        if (this.pos < this.buf.length) {
            return 0xFF & (char)this.buf[this.pos++];
        }
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException, NullPointerException, ArrayIndexOutOfBoundsException {
        if (this.buf == null) {
            throw new IOException("STREAM IS CLOSED");
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int bufsize = this.buf.length - this.pos;
        int result = 0;
        if (bufsize > len) {
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            result = len;
        } else {
            System.arraycopy(this.buf, this.pos, b, off, bufsize);
            this.pos = this.buf.length;
            result = bufsize;
            try {
                int rd = this.in.read(b, off + bufsize, len - bufsize);
                if (result == 0 || rd != -1) {
                    result += rd;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return result;
    }

    public void unread(int b) throws IOException {
        if (this.buf == null) {
            throw new IOException("STREAM IS CLOSED");
        }
        if (this.pos == 0) {
            throw new IOException("buffer full");
        }
        this.buf[--this.pos] = (byte)b;
    }

    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        if (this.buf == null) {
            throw new IOException("STREAM IS CLOSED");
        }
        if (b.length < off + len || off < 0 || len < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.pos < len) {
            throw new IOException("buffer full");
        }
        for (int i = len - 1; i >= 0; --i) {
            this.buf[--this.pos] = b[off + i];
        }
    }

    public int available() throws IOException {
        if (this.buf == null) {
            throw new IOException("STREAM IS CLOSED");
        }
        return this.in.available() + (this.buf.length - this.pos);
    }

    public long skip(long n) throws IOException {
        if (this.buf == null) {
            throw new IOException("STREAM IS CLOSED");
        }
        long bufsize = this.buf.length - this.pos;
        if (bufsize > n) {
            this.pos = (int)((long)this.pos + n);
            return n;
        }
        this.pos = this.buf.length;
        return bufsize + this.in.skip(n - bufsize);
    }

    public boolean markSupported() {
        return false;
    }
}

