/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;

    private native int createFromString(String var1);

    private native void createFromFileDescriptor(FileDescriptor var1) throws SecurityException;

    public FileInputStream(String path) throws SecurityException, FileNotFoundException {
        if (this.createFromString("." + new File(path).getAbsolutePath()) != 0) {
            throw new FileNotFoundException(path);
        }
    }

    public FileInputStream(File file) throws SecurityException, FileNotFoundException {
        if (this.createFromString("." + file.getAbsolutePath()) != 0) {
            throw new FileNotFoundException("" + file);
        }
    }

    public FileInputStream(FileDescriptor fdObj) throws SecurityException {
        this.fd = fdObj;
        this.createFromFileDescriptor(fdObj);
    }

    public synchronized native int read() throws IOException;

    private synchronized native int readIntoBuffer(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] b) throws IOException, NullPointerException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException, NullPointerException, ArrayIndexOutOfBoundsException {
        return this.readIntoBuffer(b, off, len);
    }

    public synchronized native long skip(long var1) throws IOException;

    public native int available() throws IOException;

    public synchronized native void close() throws IOException;

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.close();
        }
    }
}

