/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ByteArrayOutputStream;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.GetSystemProperty;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class File
implements Comparable,
Serializable {
    private static final long serialVersionUID = 301077366599181567L;
    private static Vector toBeDeleted;
    public static final String separator;
    public static final char separatorChar;
    public static final String pathSeparator;
    public static final char pathSeparatorChar;
    private static String current_working_dir;
    private static String current_root_dir;
    private transient String prefix;
    private transient String dirpath;
    private transient boolean absolute;
    private transient String filename = "";
    private transient String fullname;
    private transient String canonicalPath;
    private transient String absolutePath;
    private transient String absname;
    private ByteArrayOutputStream baos;
    private byte[] b;

    private static native String get_CWD();

    private static native String get_root();

    private static native void init();

    public static File[] listRoots() {
        return new File[]{new File("/")};
    }

    public static File createTempFile(String pre, String suf) throws IOException {
        return File.createTempFile(pre, suf, null);
    }

    public static File createTempFile(String pre, String suf, File dir) throws IOException {
        if (dir == null) {
            dir = new File(System.getProperties().getProperty("java.io.tmpdir", "/tmp"));
        }
        if (suf == null) {
            suf = ".tmp";
        }
        if (pre == null) {
            pre = "";
        }
        File result = new File(dir, pre + new Random().nextLong() + suf);
        result.createNewFile();
        return result;
    }

    private String pack(String path) {
        String result = "";
        LinkedList list = new LinkedList();
        StringTokenizer st = new StringTokenizer(path, "/");
        try {
            while (true) {
                String token;
                if ((token = st.nextToken()).equals(".")) {
                    continue;
                }
                if (!token.equals("..")) {
                    list.add(token);
                    continue;
                }
                if (list.size() <= 0) continue;
                list.removeLast();
            }
        }
        catch (NoSuchElementException e) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                result = result + "/" + (String)iter.next();
            }
            if (!path.startsWith("/") && result.length() > 0) {
                result = result.substring(1);
            }
            if (path.endsWith("/")) {
                result = result + "/";
            }
            return result;
        }
    }

    private String stripSlashes(String path) {
        String result = "";
        StringTokenizer st = new StringTokenizer(path, "/");
        try {
            while (true) {
                result = result + "/" + st.nextToken();
            }
        }
        catch (NoSuchElementException e) {
            if (!path.startsWith("/")) {
                result = result.substring(1);
            }
            if (path.endsWith("/")) {
                result = result + "/";
            }
            return result;
        }
    }

    public File(String path) throws NullPointerException {
        String relpath;
        if (path.length() == 0) {
            path = current_working_dir;
        }
        if (path.charAt(0) == separatorChar) {
            relpath = path.substring(1);
            this.absolute = true;
            this.prefix = "" + separatorChar;
        } else {
            relpath = path;
            this.absolute = false;
            this.prefix = "";
        }
        try {
            int dirpathlen = relpath.lastIndexOf(separatorChar);
            if (dirpathlen < 0) {
                this.dirpath = "";
                this.filename = relpath;
            } else {
                this.dirpath = relpath.substring(0, dirpathlen);
                this.filename = relpath.substring(dirpathlen + 1);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        this.fullname = path = this.stripSlashes(path);
        this.absolutePath = (this.absolute ? "" : current_working_dir) + this.fullname;
        this.absname = "." + this.absolutePath;
    }

    public File(String dirname, String name) throws NullPointerException {
        this(name == null ? null : (dirname == null ? "" : (dirname.equals("") ? "" : dirname + separatorChar)) + name);
    }

    public File(File dir, String name) throws NullPointerException {
        this(dir == null ? "" : dir.getPath(), name);
    }

    public String toString() {
        return this.fullname;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof File) {
            return ((File)obj).getPath().equals(this.getPath());
        }
        return false;
    }

    public int compareTo(File pathname) {
        return this.getPath().compareTo(pathname.getPath());
    }

    public int compareTo(Object obj) {
        if (obj instanceof File) {
            return this.absolutePath.compareTo(((File)obj).getAbsolutePath());
        }
        throw new ClassCastException();
    }

    public int hashCode() {
        return this.getPath().hashCode() ^ 0x12D591;
    }

    public String getName() {
        String result = new String(this.filename);
        int snip = this.filename.lastIndexOf(separatorChar);
        if (snip >= 0) {
            result = result.substring(snip + 1);
        }
        return result;
    }

    public String getPath() {
        return this.fullname;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public File getAbsoluteFile() {
        return new File(this.absolutePath);
    }

    public String getCanonicalPath() throws IOException {
        if (this.canonicalPath == null) {
            this.canonicalPath = this.pack(this.absolutePath);
        }
        return this.canonicalPath;
    }

    public File getCanonicalFile() throws IOException {
        return new File(this.getCanonicalPath());
    }

    public String getParent() {
        return (this.absolute ? "/" : "") + this.dirpath;
    }

    public File getParentFile() {
        return new File(this.getParent());
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isHidden() {
        return this.filename.charAt(0) == '.';
    }

    public boolean createNewFile() throws IOException {
        if (!this.exists()) {
            try {
                FileOutputStream fo = new FileOutputStream(this);
                fo.close();
                return true;
            }
            catch (FileNotFoundException e) {
                throw new IOException("Unable to create " + this);
            }
        }
        return false;
    }

    public native boolean exists() throws SecurityException;

    public native String[] list() throws SecurityException;

    public String[] list(FilenameFilter filter) throws SecurityException {
        String[] files = this.list();
        if (files == null) {
            return null;
        }
        ArrayList alist = new ArrayList(files.length);
        for (int i = 0; i < files.length; ++i) {
            if (!filter.accept(this, files[i])) continue;
            alist.add(files[i]);
        }
        Object[] result = new String[alist.size()];
        return (String[])alist.toArray(result);
    }

    public File[] listFiles() throws SecurityException {
        String[] filenames = this.list();
        if (filenames == null) {
            return null;
        }
        File[] files = new File[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            files[i] = new File(this, filenames[i]);
        }
        return files;
    }

    public File[] listFiles(FilenameFilter filter) throws SecurityException {
        String[] filenames = this.list(filter);
        if (filenames == null) {
            return null;
        }
        File[] files = new File[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            files[i] = new File(this, filenames[i]);
        }
        return files;
    }

    public File[] listFiles(FileFilter filter) throws SecurityException {
        File[] files = this.listFiles();
        if (files == null) {
            return null;
        }
        ArrayList alist = new ArrayList(files.length);
        for (int i = 0; i < files.length; ++i) {
            if (!filter.accept(files[i])) continue;
            alist.add(files[i]);
        }
        Object[] result = new File[alist.size()];
        return (File[])alist.toArray(result);
    }

    public native boolean canRead() throws SecurityException;

    public native boolean canWrite() throws SecurityException;

    public native boolean isFile() throws SecurityException;

    public native boolean isDirectory() throws SecurityException;

    public native long lastModified() throws SecurityException;

    public boolean setLastModified(long time) throws SecurityException {
        return false;
    }

    public void deleteOnExit() throws SecurityException {
        if (toBeDeleted == null) {
            File.createShutdownHook();
        }
        toBeDeleted.add(this);
    }

    private static synchronized void createShutdownHook() {
        if (toBeDeleted == null) {
            toBeDeleted = new Vector();
            Runtime.getRuntime().addShutdownHook(new Thread("File:deleteOnExit"){

                public void run() {
                    Iterator iter = toBeDeleted.iterator();
                    while (iter.hasNext()) {
                        File f = (File)iter.next();
                        try {
                            if (f == null) continue;
                            f.delete();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
    }

    public boolean setReadOnly() throws SecurityException {
        return false;
    }

    public native long length() throws SecurityException;

    public native boolean mkdir() throws SecurityException;

    public boolean mkdirs() throws SecurityException {
        boolean result = false;
        if (!this.absolutePath.equals(separator)) {
            this.getParentFile().mkdirs();
            result = this.mkdir();
        }
        return result;
    }

    private native boolean rename(String var1, String var2);

    public boolean renameTo(File dest) throws SecurityException {
        return this.rename(this.absolutePath, dest.getAbsolutePath());
    }

    public native boolean delete() throws SecurityException;

    public URL toURL() throws MalformedURLException {
        if (this.canonicalPath == null) {
            this.canonicalPath = this.pack(this.absolutePath);
        }
        return new URL("file", "", this.canonicalPath);
    }

    static {
        int i;
        current_working_dir = null;
        current_root_dir = null;
        File.init();
        current_working_dir = File.get_CWD();
        current_root_dir = File.get_root();
        char[] working = current_working_dir.toCharArray();
        char[] root = current_root_dir.toCharArray();
        int root_length = root.length;
        int pwd_length = working.length;
        for (i = 0; i < root_length && i < pwd_length && working[i] == root[i]; ++i) {
        }
        current_working_dir = i == root_length ? "/" + current_working_dir.substring(i) + "/" : "/";
        separator = GetSystemProperty.FILE_SEPARATOR;
        pathSeparator = GetSystemProperty.PATH_SEPARATOR;
        separatorChar = separator.charAt(0);
        pathSeparatorChar = pathSeparator.charAt(0);
        System.getProperties().setProperty("user.dir", current_working_dir);
    }
}

