/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("negative size " + size);
        }
        this.buf = new byte[size];
    }

    public synchronized void write(int b) {
        if (this.buf.length <= this.count) {
            byte[] bytes = new byte[(this.count + 1) * 2];
            System.arraycopy(this.buf, 0, bytes, 0, this.count);
            this.buf = bytes;
        }
        this.buf[this.count++] = (byte)b;
    }

    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.count + len > this.buf.length) {
            int c = (this.count + 1) * 2;
            byte[] bytes = new byte[c > this.count + len ? c : this.count + len];
            System.arraycopy(this.buf, 0, bytes, 0, this.count);
            this.buf = bytes;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public int size() {
        return this.count;
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        byte[] result = new byte[this.count];
        System.arraycopy(this.buf, 0, result, 0, this.count);
        return result;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(int hibyte) {
        return new String(this.buf, hibyte, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void close() throws IOException {
    }
}

