/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int count;
    protected int mark;

    public ByteArrayInputStream(byte[] b) {
        this(b, 0, b.length);
    }

    public ByteArrayInputStream(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.buf = b;
        this.count = off + len > b.length ? b.length - off : off + len;
        this.pos = off;
        this.mark = off;
    }

    public synchronized int read() {
        if (this.pos >= this.count) {
            return -1;
        }
        return 0xFF & (char)this.buf[this.pos++];
    }

    public void close() throws IOException {
    }

    public synchronized int read(byte[] b, int off, int len) {
        if (this.pos >= this.count) {
            return -1;
        }
        int k = this.count - this.pos;
        k = len > k ? k : len;
        System.arraycopy(this.buf, this.pos, b, off, k);
        this.pos += k;
        return k;
    }

    public synchronized long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        int k = this.count - this.pos;
        k = n > (long)k ? k : (int)n;
        this.pos += k;
        return k;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public synchronized void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public boolean markSupported() {
        return true;
    }
}

