/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int count = 0;
    protected int pos = 0;
    protected int marklimit = 0;
    protected int markpos = -1;

    public BufferedInputStream(InputStream in) {
        super(in);
        this.buf = new byte[2048];
    }

    public BufferedInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size should be > 0");
        }
        this.buf = new byte[size];
    }

    public int read() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream is closed");
        }
        if (this.count <= this.pos && !this.updateBuffer(1)) {
            return -1;
        }
        ++this.pos;
        if (this.buf == null) {
            throw new IOException("Stream is closed");
        }
        return 0xFF & (char)this.buf[this.pos - 1];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream is closed");
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.checkSize(len);
        int rd = 0;
        if (this.count > this.pos) {
            int cp = this.count - this.pos;
            if (len > cp) {
                System.arraycopy(this.buf, this.pos, b, off, cp);
                off += cp;
                len -= cp;
                this.pos += cp;
                rd += cp;
            } else {
                System.arraycopy(this.buf, this.pos, b, off, len);
                this.pos += len;
                return len;
            }
        }
        if (len > this.buf.length && (this.markpos == -1 || this.pos + len > this.markpos + this.marklimit)) {
            rd += this.in.read(b, off, len);
            this.markpos = -1;
        } else if (this.updateBuffer(len)) {
            int n = len = len > this.count - this.pos ? this.count - this.pos : len;
            if (this.buf == null) {
                throw new IOException("Stream is closed");
            }
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            rd += len;
        }
        return rd == 0 ? -1 : rd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long skip(long n) throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream is closed");
        }
        if (n <= 0L) {
            return 0L;
        }
        this.checkSize(n);
        if (n - (long)this.count + (long)this.pos > 0L) {
            if (this.count == this.pos) {
                if (n > (long)this.buf.length) {
                    this.markpos = -1;
                    return this.in.skip(n);
                }
                if (!this.updateBuffer((int)n)) return 0L;
                if (n - (long)this.count + (long)this.pos > 0L) {
                    int ret = this.count - this.pos;
                    this.pos = this.count;
                    return ret;
                }
            } else {
                int ret = this.count - this.pos;
                this.pos = this.count;
                return ret;
            }
        }
        this.pos += (int)n;
        return n;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int markLimit) {
        this.marklimit = markLimit;
        this.markpos = this.pos;
    }

    public void reset() throws IOException {
        if (this.buf == null || this.markpos == -1 || this.pos > this.markpos + this.marklimit) {
            throw new IOException();
        }
        this.pos = this.markpos;
    }

    public void close() throws IOException {
        if (this.buf != null) {
            this.markpos = -1;
            this.marklimit = 0;
            this.in.close();
            this.buf = null;
            this.in = null;
        }
    }

    public int available() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream is closed");
        }
        return this.count - this.pos + this.in.available();
    }

    private void checkSize(long need) throws IOException {
        if (this.markpos == 0 && this.marklimit > this.buf.length && (long)this.pos + need > (long)this.buf.length) {
            byte[] bytes = new byte[this.marklimit];
            System.arraycopy(this.buf, 0, bytes, 0, this.count);
            int cp = this.in.read(bytes, this.count, this.marklimit - this.count);
            this.buf = bytes;
            if (cp > 0) {
                this.count += cp;
            }
        }
    }

    private boolean updateBuffer(int want) throws IOException {
        if (this.markpos == -1 || this.pos + want > this.markpos + this.marklimit) {
            if (this.markpos != -1 && this.marklimit > this.buf.length) {
                this.buf = new byte[this.marklimit];
            }
            this.count = this.in.read(this.buf, 0, this.buf.length);
            this.pos = 0;
            this.markpos = -1;
            if (this.count == -1) {
                this.count = 0;
                return false;
            }
            return true;
        }
        byte[] bytes = this.buf;
        int cp = this.count - this.markpos;
        if (this.marklimit > this.buf.length && cp >= this.buf.length) {
            bytes = new byte[this.marklimit];
        }
        System.arraycopy(this.buf, this.markpos, bytes, 0, cp);
        this.count = this.in.read(bytes, cp, bytes.length - cp);
        this.pos = cp;
        this.markpos = 0;
        this.buf = bytes;
        if (this.count == -1) {
            this.count = cp;
            return false;
        }
        this.count += cp;
        return true;
    }
}

