/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class ReplicateScaleFilter
extends ImageFilter {
    protected int destHeight;
    protected int destWidth;
    protected int srcHeight;
    protected int srcWidth;
    protected Object outpixbuf;
    protected int[] srccols;
    protected int[] srcrows;

    public void setDimensions(int w, int h) {
        super.setDimensions(this.destWidth, this.destHeight);
        this.srcHeight = h;
        this.srcWidth = w;
        this.srccols = new int[this.srcWidth + 1];
        this.srcrows = new int[this.srcHeight + 1];
        int i = 0;
        while (i <= this.srcWidth) {
            this.srccols[i] = i * this.destWidth / this.srcWidth;
            ++i;
        }
        i = 0;
        while (i <= this.srcHeight) {
            this.srcrows[i] = i * this.destHeight / this.srcHeight;
            ++i;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int nw = this.srccols[x + w] - this.srccols[x];
        int nh = this.srcrows[y + h] - this.srcrows[y];
        byte[] newpixels = new byte[nw * nh];
        int i = 0;
        while (i < h) {
            int j = 0;
            while (j < w) {
                int k = 0;
                while (k < this.srcrows[y + i + 1] - this.srcrows[y + i]) {
                    int l = 0;
                    while (l < this.srccols[x + j + 1] - this.srccols[x + j]) {
                        newpixels[(this.srcrows[y + i] - this.srcrows[y] + k) * nw + (this.srccols[x + j] - this.srccols[x] + l)] = pixels[i * scansize + j + off];
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        super.setPixels(this.srccols[x], this.srcrows[y], nw, nh, model, newpixels, 0, nw);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int nw = this.srccols[x + w] - this.srccols[x];
        int nh = this.srcrows[y + h] - this.srcrows[y];
        int[] newpixels = new int[nw * nh];
        int i = 0;
        while (i < h) {
            int j = 0;
            while (j < w) {
                int k = 0;
                while (k < this.srcrows[y + i + 1] - this.srcrows[y + i]) {
                    int l = 0;
                    while (l < this.srccols[x + j + 1] - this.srccols[x + j]) {
                        newpixels[(this.srcrows[y + i] - this.srcrows[y] + k) * nw + (this.srccols[x + j] - this.srccols[x] + l)] = pixels[i * scansize + j + off];
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        super.setPixels(this.srccols[x], this.srcrows[y], nw, nh, model, newpixels, 0, nw);
    }

    public void setProperties(Hashtable props) {
        super.setProperties(props);
    }

    public ReplicateScaleFilter(int width, int height) {
        this.destHeight = height;
        this.destWidth = width;
    }
}

