/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;

public class DirectColorModel
extends ColorModel {
    private int rmask;
    private int gmask;
    private int bmask;
    private int amask;
    private int rmaskbits;
    private int gmaskbits;
    private int bmaskbits;
    private int amaskbits;
    private int rmaskpos;
    private int gmaskpos;
    private int bmaskpos;
    private int amaskpos;

    public DirectColorModel(int bits, int rmask, int gmask, int bmask) {
        this(bits, rmask, gmask, bmask, 0);
    }

    public DirectColorModel(int bits, int rmask, int gmask, int bmask, int amask) {
        super(bits);
        this.rmask = rmask;
        this.gmask = gmask;
        this.bmask = bmask;
        this.amask = amask;
        if (rmask != 0) {
            this.rmaskpos = this.getPos(rmask);
            this.rmaskbits = this.getBits(rmask, this.rmaskpos);
        }
        if (gmask != 0) {
            this.gmaskpos = this.getPos(gmask);
            this.gmaskbits = this.getBits(gmask, this.gmaskpos);
        }
        if (bmask != 0) {
            this.bmaskpos = this.getPos(bmask);
            this.bmaskbits = this.getBits(bmask, this.bmaskpos);
        }
        if (amask != 0) {
            this.amaskpos = this.getPos(amask);
            this.amaskbits = this.getBits(amask, this.amaskpos);
        }
    }

    private int getPos(int val) {
        int result = 0;
        while ((val & 1) == 0) {
            val >>>= 1;
            ++result;
        }
        return result;
    }

    private int getBits(int val, int pos) {
        int result = 0;
        val >>>= pos;
        while ((val & 1) == 1) {
            val >>>= 1;
            ++result;
        }
        return result;
    }

    public final int getAlpha(int pixelValue) {
        if (this.amask == 0) {
            return 255;
        }
        return (pixelValue & this.amask) >>> this.amaskpos << 8 >>> this.amaskbits;
    }

    public final int getAlphaMask() {
        return this.amask;
    }

    public final int getRed(int pixelValue) {
        if (this.rmask == 0) {
            return 0;
        }
        return (pixelValue & this.rmask) >>> this.rmaskpos << 8 >>> this.rmaskbits;
    }

    public final int getRedMask() {
        return this.rmask;
    }

    public final int getGreen(int pixelValue) {
        if (this.gmask == 0) {
            return 0;
        }
        return (pixelValue & this.gmask) >>> this.gmaskpos << 8 >>> this.gmaskbits;
    }

    public final int getGreenMask() {
        return this.gmask;
    }

    public final int getBlue(int pixelValue) {
        if (this.bmask == 0) {
            return 0;
        }
        return (pixelValue & this.bmask) >>> this.bmaskpos << 8 >>> this.bmaskbits;
    }

    public final int getBlueMask() {
        return this.bmask;
    }

    public final int getRGB(int pixelValue) {
        return this.getAlpha(pixelValue) << 24 | this.getRed(pixelValue) << 16 | this.getGreen(pixelValue) << 8 | this.getBlue(pixelValue);
    }
}

