/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class CropImageFilter
extends ImageFilter {
    private int sx;
    private int sy;
    private int sw;
    private int sh;

    public void setDimensions(int width, int height) {
        super.setDimensions(this.sw, this.sh);
    }

    public void setProperties(Hashtable properties) {
        super.setProperties(properties);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int ox = this.sx - x;
        int oy = this.sy - y;
        int nw = this.sw;
        int nh = this.sh;
        if (ox < 0) {
            nw += ox;
            ox = 0;
        }
        if (oy < 0) {
            nh += oy;
            oy = 0;
        }
        if (this.sx + this.sw > x + w) {
            nw -= this.sw - (x + w - this.sx);
        }
        if (this.sy + this.sh > y + h) {
            nh -= this.sh - (y + h - this.sy);
        }
        if (nw > 0 && nh > 0) {
            byte[] newpixels = new byte[nw * nh];
            int i = 0;
            while (i < nh) {
                int j = 0;
                while (j < nw) {
                    newpixels[i * nw + j] = pixels[(i + oy) * scansize + (j + ox) + off];
                    ++j;
                }
                ++i;
            }
            int n = 0;
            if (x - this.sx > 0) {
                n = x - this.sx;
            }
            int n2 = 0;
            if (y - this.sy > 0) {
                n2 = y - this.sy;
            }
            super.setPixels(n, n2, nw, nh, model, newpixels, 0, nw);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int ox = this.sx - x;
        int oy = this.sy - y;
        int nw = this.sw;
        int nh = this.sh;
        if (ox < 0) {
            nw += ox;
            ox = 0;
        }
        if (oy < 0) {
            nh += oy;
            oy = 0;
        }
        if (this.sx + this.sw > x + w) {
            nw -= this.sw - (x + w - this.sx);
        }
        if (this.sy + this.sh > y + h) {
            nh -= this.sh - (y + h - this.sy);
        }
        if (nw > 0 && nh > 0) {
            int[] newpixels = new int[nw * nh];
            int i = 0;
            while (i < nh) {
                int j = 0;
                while (j < nw) {
                    newpixels[i * nw + j] = pixels[(i + oy) * scansize + (j + ox) + off];
                    ++j;
                }
                ++i;
            }
            int n = 0;
            if (x - this.sx > 0) {
                n = x - this.sx;
            }
            int n2 = 0;
            if (y - this.sy > 0) {
                n2 = y - this.sy;
            }
            super.setPixels(n, n2, nw, nh, model, newpixels, 0, nw);
        }
    }

    public CropImageFilter(int x, int y, int width, int height) {
        this.sx = x;
        this.sy = y;
        this.sw = width;
        this.sh = height;
    }
}

