/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ComponentPeer;
import java.io.Serializable;
import java.util.TooManyListenersException;

public class DropTarget
implements DropTargetListener,
Serializable {
    private Component component;
    private int actions = 3;
    private boolean active = true;
    private FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
    private DropTargetListener dtListener;
    private DropTargetContext dropTargetContext;
    private ComponentPeer peer;
    private DropTargetAutoScroller scroller;
    private Point p = new Point();

    public DropTarget(Component c, int ops, DropTargetListener dtl, boolean act, FlavorMap fm) {
        this.component = c;
        this.actions = ops;
        this.dtListener = dtl;
        this.active = act;
        this.flavorMap = fm;
        this.scroller = this.createDropTargetAutoScroller(this.component, this.p);
        this.dropTargetContext = this.createDropTargetContext();
        this.component.setDropTarget(this);
    }

    public DropTarget(Component c, int ops, DropTargetListener dtl, boolean act) {
        this.component = c;
        this.actions = ops;
        this.dtListener = dtl;
        this.active = act;
        this.scroller = this.createDropTargetAutoScroller(this.component, this.p);
        this.dropTargetContext = this.createDropTargetContext();
        this.component.setDropTarget(this);
        this.component.setEnabled(this.active);
    }

    public DropTarget(Component c, int ops, DropTargetListener dtl) {
        this.component = c;
        this.actions = ops;
        this.dtListener = dtl;
        this.scroller = this.createDropTargetAutoScroller(this.component, this.p);
        this.dropTargetContext = this.createDropTargetContext();
        this.component.setDropTarget(this);
        this.component.setEnabled(this.active);
    }

    public DropTarget(Component c, DropTargetListener dtl) {
        this.component = c;
        this.dtListener = dtl;
        this.scroller = this.createDropTargetAutoScroller(this.component, this.p);
        this.dropTargetContext = this.createDropTargetContext();
        this.component.setDropTarget(this);
        this.component.setEnabled(this.active);
    }

    public DropTarget() {
        this.scroller = this.createDropTargetAutoScroller(this.component, this.p);
        this.dropTargetContext = this.createDropTargetContext();
    }

    public void setComponent(Component c) {
        this.component = c;
        this.scroller = this.createDropTargetAutoScroller(this.component, this.p);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setDefaultActions(int ops) {
        this.actions = ops;
    }

    public int getDefaultActions() {
        return this.actions;
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    public boolean isActive() {
        return this.active;
    }

    public void addDropTargetListener(DropTargetListener dtl) throws TooManyListenersException {
        if (this.dtListener != null) {
            throw new TooManyListenersException();
        }
        this.dtListener = dtl;
    }

    public void removeDropTargetListener(DropTargetListener dtl) {
        if (this.dtListener.equals(dtl)) {
            this.dtListener = null;
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.dtListener != null) {
            this.dtListener.dragEnter(dtde);
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (this.dtListener != null) {
            this.dtListener.dragOver(dtde);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        if (this.dtListener != null) {
            this.dtListener.dropActionChanged(dtde);
        }
    }

    public void dragExit(DropTargetEvent dte) {
        if (this.dtListener != null) {
            this.dtListener.dragExit(dte);
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        if (this.dtListener != null) {
            this.dtListener.drop(dtde);
        }
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public void setFlavorMap(FlavorMap fm) {
        this.flavorMap = fm;
    }

    public void addNotify(ComponentPeer peer) {
        this.peer = peer;
    }

    public void removeNotify(ComponentPeer peer) {
        if (this.peer.equals(peer)) {
            this.peer = null;
        }
    }

    public DropTargetContext getDropTargetContext() {
        return this.dropTargetContext;
    }

    protected DropTargetContext createDropTargetContext() {
        com.acunia.wonka.rudolph.DropTargetContext dtc = new com.acunia.wonka.rudolph.DropTargetContext(this);
        return dtc;
    }

    protected DropTargetAutoScroller createDropTargetAutoScroller(Component c, Point p) {
        return new DropTargetAutoScroller(c, p);
    }

    protected void initializeAutoscrolling(Point p) {
        this.scroller.stop();
        this.scroller.updateLocation(p);
    }

    protected void updateAutoscroll(Point dragCursorLocn) {
        this.scroller.updateLocation(dragCursorLocn);
    }

    protected void clearAutoscroll() {
        this.scroller.stop();
    }

    protected static class DropTargetAutoScroller
    implements ActionListener {
        private Component component;
        private Point beginpoint;
        private Point endpoint;
        private boolean updaten;

        protected DropTargetAutoScroller(Component c, Point p) {
            this.component = c;
            this.beginpoint = p;
            this.updaten = true;
        }

        protected void updateLocation(Point newLocn) {
            if (this.updaten) {
                this.endpoint = newLocn;
            } else {
                this.beginpoint = newLocn;
            }
            this.updaten = true;
        }

        protected void stop() {
            this.updaten = false;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.updaten) {
                // empty if block
            }
        }
    }
}

