/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;

public class DragSource {
    private DragSourceContext dragSourceContext;
    private FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
    private static boolean dragImageSupported = false;
    public static final Cursor DefaultCopyDrop = Toolkit.getDefaultToolkit().createCustomCursor(null, new Point(32, 32), "CopyDrop32x32");
    public static final Cursor DefaultMoveDrop = Toolkit.getDefaultToolkit().createCustomCursor(null, new Point(32, 32), "MoveDrop32x32");
    public static final Cursor DefaultLinkDrop = Toolkit.getDefaultToolkit().createCustomCursor(null, new Point(32, 32), "LinkDrop32x32");
    public static final Cursor DefaultCopyNoDrop = Toolkit.getDefaultToolkit().createCustomCursor(null, new Point(32, 32), "CopyNoDrop32x32");
    public static final Cursor DefaultMoveNoDrop = Toolkit.getDefaultToolkit().createCustomCursor(null, new Point(32, 32), "MoveNoDrop32x32");
    public static final Cursor DefaultLinkNoDrop = Toolkit.getDefaultToolkit().createCustomCursor(null, new Point(32, 32), "LinkNoDrop32x32");
    static /* synthetic */ Class class$java$awt$dnd$MouseDragGestureRecognizer;

    public static DragSource getDefaultDragSource() {
        return new DragSource();
    }

    public static boolean isDragImageSupported() {
        return dragImageSupported;
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point imageOffset, Transferable transferable, DragSourceListener dsl, FlavorMap flavorMap) throws InvalidDnDOperationException {
        this.flavorMap = flavorMap;
        DragSourceContextPeer dscp = Toolkit.getDefaultToolkit().createDragSourceContextPeer(trigger);
        this.dragSourceContext = this.createDragSourceContext(dscp, trigger, dragCursor, dragImage, imageOffset, transferable, dsl);
        dscp.startDrag(this.dragSourceContext, dragCursor, dragImage, imageOffset);
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Transferable transferable, DragSourceListener dsl, FlavorMap flavorMap) throws InvalidDnDOperationException {
        this.flavorMap = flavorMap;
        DragSourceContextPeer dscp = Toolkit.getDefaultToolkit().createDragSourceContextPeer(trigger);
        Image dragImage = null;
        Point imageOffset = null;
        this.dragSourceContext = this.createDragSourceContext(dscp, trigger, dragCursor, dragImage, imageOffset, transferable, dsl);
        dscp.startDrag(this.dragSourceContext, dragCursor, dragImage, imageOffset);
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point dragOffset, Transferable transferable, DragSourceListener dsl) throws InvalidDnDOperationException {
        DragSourceContextPeer dscp = Toolkit.getDefaultToolkit().createDragSourceContextPeer(trigger);
        Point imageOffset = null;
        this.dragSourceContext = this.createDragSourceContext(dscp, trigger, dragCursor, dragImage, imageOffset, transferable, dsl);
        dscp.startDrag(this.dragSourceContext, dragCursor, dragImage, imageOffset);
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Transferable transferable, DragSourceListener dsl) throws InvalidDnDOperationException {
        DragSourceContextPeer dscp = Toolkit.getDefaultToolkit().createDragSourceContextPeer(trigger);
        Image dragImage = null;
        Point imageOffset = null;
        this.dragSourceContext = this.createDragSourceContext(dscp, trigger, dragCursor, dragImage, imageOffset, transferable, dsl);
        dscp.startDrag(this.dragSourceContext, dragCursor, dragImage, imageOffset);
    }

    protected DragSourceContext createDragSourceContext(DragSourceContextPeer dscp, DragGestureEvent dgl, Cursor dragCursor, Image dragImage, Point imageOffset, Transferable t, DragSourceListener dsl) {
        return new DragSourceContext(dscp, dgl, dragCursor, dragImage, imageOffset, t, dsl);
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public DragGestureRecognizer createDragGestureRecognizer(Class recognizerAbstractClass, Component c, int actions, DragGestureListener dgl) {
        return Toolkit.getDefaultToolkit().createDragGestureRecognizer(recognizerAbstractClass, this, c, actions, dgl);
    }

    public DragGestureRecognizer createDefaultDragGestureRecognizer(Component c, int actions, DragGestureListener dgl) {
        return Toolkit.getDefaultToolkit().createDragGestureRecognizer(class$java$awt$dnd$MouseDragGestureRecognizer == null ? (class$java$awt$dnd$MouseDragGestureRecognizer = DragSource.class$("java.awt.dnd.MouseDragGestureRecognizer")) : class$java$awt$dnd$MouseDragGestureRecognizer, this, c, actions, dgl);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

