/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import com.acunia.wonka.rudolph.DropTargetEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.TooManyListenersException;

public abstract class DragGestureRecognizer {
    protected DragSource dragSource;
    protected Component component;
    protected DragGestureListener dragGestureListener;
    protected int sourceActions;
    protected ArrayList events;

    protected DragGestureRecognizer(DragSource ds, Component c, int sa, DragGestureListener dgl) {
        if (ds == null) {
            throw new IllegalArgumentException();
        }
        this.dragSource = ds;
        this.component = c;
        this.sourceActions = sa;
        this.dragGestureListener = dgl;
        this.registerListeners();
    }

    protected DragGestureRecognizer(DragSource ds, Component c, int sa) {
        if (ds == null) {
            throw new IllegalArgumentException();
        }
        this.dragSource = ds;
        this.component = c;
        this.sourceActions = sa;
        this.registerListeners();
    }

    protected DragGestureRecognizer(DragSource ds, Component c) {
        if (ds == null) {
            throw new IllegalArgumentException();
        }
        this.dragSource = ds;
        this.component = c;
        this.registerListeners();
    }

    protected DragGestureRecognizer(DragSource ds) {
        if (ds == null) {
            throw new IllegalArgumentException();
        }
        this.dragSource = ds;
    }

    protected abstract void registerListeners();

    protected abstract void unregisterListeners();

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component c) {
        if (this.component != null) {
            this.unregisterListeners();
        }
        this.component = c;
        this.registerListeners();
    }

    public int getSourceActions() {
        return this.sourceActions;
    }

    public void setSourceActions(int actions) {
        this.sourceActions = actions;
    }

    public InputEvent getTriggerEvent() {
        if (this.events != null) {
            return (InputEvent)this.events.get(0);
        }
        return null;
    }

    public void resetRecognizer() {
        DropTargetEvent.setInProgress(false, null);
        this.events = null;
    }

    public void addDragGestureListener(DragGestureListener dgl) throws TooManyListenersException {
        if (this.dragGestureListener != null) {
            throw new TooManyListenersException();
        }
        this.dragGestureListener = dgl;
    }

    public void removeDragGestureListener(DragGestureListener dgl) {
        if (!this.dragGestureListener.equals(dgl)) {
            throw new IllegalArgumentException();
        }
        this.dragGestureListener = null;
    }

    protected void fireDragGestureRecognized(int dragAction, Point p) {
        this.dragGestureListener.dragGestureRecognized(new DragGestureEvent(this, dragAction, p, this.events));
        this.events = null;
    }

    protected void appendEvent(InputEvent awtie) {
        if (awtie != null) {
            ArrayList al = this.events == null ? new ArrayList(1) : new ArrayList(this.events.size() + 1);
            for (int i = 0; i < al.size(); ++i) {
                al.add(i, this.events.get(i));
            }
            al.add(al.size(), awtie);
            this.events = al;
        }
    }
}

